% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tri2verts.R
\name{tri2verts}
\alias{tri2verts}
\title{Triangles to vertices}
\usage{
tri2verts(mesh,values)
}
\arguments{
\item{mesh}{a \code{mesh3d} object.}

\item{values}{a vector of continuous values associated to individual triangles
of the \code{mesh}.}
}
\value{
A vector of continuous values associated to individual vertices of
  the \code{mesh}.
}
\description{
The function transfers values associated to triangles of a
  \code{mesh3d} object to its vertices.
}
\examples{
  \donttest{
  da<-"https://github.com/pasraia/RRmorph_example_data/raw/refs/heads/main/RRmorphdata.rda"
  download.file(url=da,destfile = paste0(tempdir(),"/RRmorphdata.rda"))
  load(paste0(tempdir(),"/RRmorphdata.rda"))

  require(Morpho)
  require(Rvcg)

  pca<-procSym(endo.set)
  ldm<-endo.set[,,"Homo_sapiens"]
  sur<-endo.sur[["Homo_sapiens"]]

  rec<- vcgBallPivoting(pca$mshape, radius = 0)
  rec$vb[1:3,]<-t(ldm)
  val<-rnorm(ncol(rec$vb))

  vertval<-tri2verts(rec,val)
  }
}
\author{
Marina Melchionna, Silvia Castiglione
}
