% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contour.radviz.R
\name{contour.radviz}
\alias{contour.radviz}
\title{Plots the Dimensional Anchors and density lines for projected data points in a 2D space.}
\usage{
\method{contour}{radviz}(
  x,
  ...,
  main = NULL,
  color = NULL,
  size = 0.5,
  label.color = NULL,
  label.size = NULL,
  contour.color,
  contour.size,
  point.color,
  point.shape,
  point.size,
  n,
  drawlabels,
  drawpoints,
  add
)
}
\arguments{
\item{x}{a radviz object as produced by do.radviz}

\item{...}{further arguments to be passed to or from other methods (not implemented)}

\item{main}{[Optional] a title to the graph, displayed on top}

\item{color}{the variable in the Radviz projection used to color the contours}

\item{size}{The thickness of contour lines}

\item{label.color}{the color of springs for visualization}

\item{label.size}{the size of the anchors (see \href{https://ggplot2.tidyverse.org/articles/articles/faq-customising.html}{customizing ggplot2} for details on default value)}

\item{contour.color}{deprecated, see \code{\link[ggplot2]{geom_density2d}} instead}

\item{contour.size}{deprecated, see \code{\link[ggplot2]{geom_density2d}} instead}

\item{point.color}{deprecated, see \code{\link[ggplot2]{geom_density2d}} instead}

\item{point.shape}{deprecated, see \code{\link[ggplot2]{geom_density2d}} instead}

\item{point.size}{deprecated, see \code{\link[ggplot2]{geom_density2d}} instead}

\item{n}{deprecated, see \code{\link[ggplot2]{geom_density2d}} instead}

\item{drawlabels}{deprecated, see \code{\link[ggplot2]{geom_density2d}} instead}

\item{drawpoints}{deprecated, see \code{\link[ggplot2]{geom_density2d}} instead}

\item{add}{deprecated, see \code{\link[ggplot2]{geom_density2d}} instead}
}
\value{
the internal ggplot2 object plus added layers, allowing for extra geoms to be added
}
\description{
Plots the Dimensional Anchors and density lines for projected data points in a 2D space.
}
\examples{
data(iris)
das <- c('Sepal.Length','Sepal.Width','Petal.Length','Petal.Width')
S <- make.S(das)
rv <- do.radviz(iris,S)
contour(rv,color='Species')

}
\author{
Yann Abraham
}
\keyword{hplot}
\keyword{multivariate}
