% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.dfunc.r
\name{print.dfunc}
\alias{print.dfunc}
\title{Print method for distance function object}
\usage{
\method{print}{dfunc}(x, ...)
}
\arguments{
\item{x}{An estimated detection function object, normally 
produced by calling \code{\link{dfuncEstim}}.}

\item{\dots}{Included for compatibility with other print methods.  Ignored here.}
}
\value{
The input distance function (\code{x}) is returned invisibly.
}
\description{
Print method for distance function objects produced 
by \code{dfuncEstim}.
}
\examples{
# Load example sparrow data (line transect survey type)
data(sparrowSiteData)
data(sparrowDetectionData)

# Fit half-normal detection function
sparrowDf <- RdistDf(sparrowSiteData, sparrowDetectionData)
dfunc <- sparrowDf |> dfuncEstim(formula=dist~1)

dfunc

}
\seealso{
\code{\link{dfuncEstim}}, \code{\link{plot.dfunc}}, 
\code{\link{print.abund}}, \code{\link{summary.dfunc}}
}
