#' Distance between points in the same group
#'
#'
#' This function calculates the distance between points in the same group. This function calculates the distance between the pair of points in the group. Then, takes the maximum distance.
#'
#' @param data Matrix with \code{dim(data)[1]} points of \code{dim(data)[2]} dimensions.
#' @param group1 Number. Number of the group.
#' @param distance Function. This function designs how the distance is going to be calculated. It must have as input two vectors and as output the distance of these vectors.
#' @param FHW_output List. List with:
#'
#' \itemize{
#'   \item centers: the information of the centers updated.
#'   \item grouping: the information of the groups updated. List. Each component of the list contains a vector with the points that belong to that group. More specifically, the list component i has a vector with the numbers of the row of the matrix \code{data} where the points belonging to group i are.
#'    }
#'
#' @return Returns a number, the value of the maximum distance between pair of points of the group.
#'
#'
#'
#' @examples
#'
#'set.seed(451)
#'data=rbind(matrix(runif(30,1,5), nrow = 3, ncol = 10),
#'           matrix(runif(20,20,30), nrow = 2, ncol = 10),
#'           matrix(runif(20,50,70), nrow = 2, ncol = 10))
#'k=3
#'seed=5
#'
#'
#'FHW_output=Hartigan_and_Wong(data,
#'                             Euclideandistance,
#'                             k,
#'                             centers_function_mean,
#'                             init_centers_random,
#'                             seed=seed,
#'                             10)
#'
#'DistanceSameGroup(2,  FHW_output, data, Euclideandistance)
#' @export

DistanceSameGroup<-function(group1,  FHW_output, data, distance){

  G1_points=FHW_output$grouping[[group1]]

  if(length(G1_points)==1){
    max_dist_clust=0
    return(max_dist_clust)
  }else{


  mat=utils::combn(G1_points, 2)

  dist_mat=rep(0, dim(mat)[2])
  for (i in 1:(dim(mat)[2])){
    dist_mat[i]=distance(data[mat[1,i],] , data[mat[2,i],])
  }

  max_dist_clust=max(dist_mat)

  return(max_dist_clust)
  }
}
