% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Silhouette.R
\name{Silhouette}
\alias{Silhouette}
\title{Silhouette}
\usage{
Silhouette(data, FHW_output, distance)
}
\arguments{
\item{data}{Matrix with \code{dim(data)[1]} points of \code{dim(data)[2]} dimensions.}

\item{FHW_output}{List. List with:

\itemize{
  \item centers: the information of the centers updated.
  \item grouping: the information of the groups updated. List. Each component of the list contains a vector with the points that belong to that group. More specifically, the list component i has a vector with the numbers of the row of the matrix \code{data} where the points belonging to group i are.
   }}

\item{distance}{Function. This function designs how the distance is going to be calculated. It must have as input two vectors and as output the distance of these vectors.}
}
\value{
Returns a vector. The component i contains the Silhouette value of the point in the row i of the \code{data} matrix.
}
\description{
This function calculates the Silhouette as is defined in Rousseeuw (1987) without imposing that the use of the euclidean distance. This allows calculating the Silhouette using different distances. Note that the Silhouette must be calculated using a distance that is a a ratio scale (Rousseeuw, 1987).
}
\examples{

set.seed(451)
data=rbind(matrix(runif(20,1,5), nrow = 2, ncol = 10),
          matrix(runif(20,20,30), nrow = 2, ncol = 10),
          matrix(runif(20,50,70), nrow = 2, ncol = 10))
k=3
seed=5

FHW_output=Hartigan_and_Wong(data,
                            Euclideandistance,
                            k,
                            centers_function_mean,
                            init_centers_random,
                            seed=seed,
                            10)

Silhouette(data, FHW_output, Euclideandistance)

}
\references{
Rousseeuw, P.J. (1987) Silhouettes: A graphical aid to the interpretation and validation of cluster analysis. J. Comput. Appl. Math., 20, 53--65.
}
