% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{iclaims.example}
\alias{iclaims.example}
\title{Weekly Initial Claims of US Unemployment Benefits & Google Trends Queries}
\format{
A data frame with 443 rows and 5 variables with log-transformation
\describe{
  \item{week}{date of records starting by Mondays with US calendar format}
  \item{claims}{weekly initial claims of unemployment benefits in thousands}
  \item{trend.unemploy}{normalized trend queries retreived from gtrendsR API}
  \item{trend.filling}{normalized trend queries retreived from gtrendsR API}
  \item{trend.job}{normalized trend queries retreived from gtrendsR API}
}
}
\usage{
data("iclaims.example")
}
\description{
A dataset containing the weekly initial claims for US unemployment benefits against 
a few related Google trend queries from Jan 2010 - June 2018. 
This aims to mimick the dataset from Scott and Varian (2014).
}
\references{
U.S. Employment and Training Administration, Initial Claims [ICNSA], retrieved from FRED, Federal Reserve Bank of St. Louis; 
\url{https://fred.stlouisfed.org/series/ICNSA}, October 27, 2018.

Trend queries from Google search engine. 
\url{https://trends.google.com/trends/?geo=US}

An interface for retrieving and displaying the information returned online by Google Trends is provided. Trends (number of hits) over the time as well as geographic representation of the results can be displayed.
\url{https://CRAN.R-project.org/package=gtrendsR}

Scott, S. L. and Varian, H. R. (2014). Predicting the Present with Bayesian Structural Time Series.
International Journal of Mathematical Modeling and Optimization 5 4–23.
}
\keyword{datasets}
