% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_interval.rlgtfit.R
\name{posterior_interval.rlgtfit}
\alias{posterior_interval.rlgtfit}
\title{rlgtfit posterior interval}
\usage{
\method{posterior_interval}{rlgtfit}(object, prob = 0.9, type = "central", ...)
}
\arguments{
\item{object}{an object of class rlgtfit}

\item{prob}{percentile level to be generated (multiple values can be accepted as a vector)}

\item{type}{currently only central is available}

\item{...}{currently not in use}
}
\value{
confidence interval
}
\description{
This is a method of the \code{link{rlgtfit}} class to produce posterior intervals
}
\examples{
# The following is a toy example that runs within a few seconds. To get good 
# fitting results the number of iterations should be set to at least 2000, and 
# 4 chains should be used (the default). To speed up computation the number of 
# cores should also be adjusted (default is 4).

rlgt_model <- rlgt(lynx, method = "Stan",
       control=rlgt.control(MAX_NUM_OF_REPEATS=1, NUM_OF_ITER=50, NUM_OF_CHAINS = 1, 
                            NUM_OF_CORES = 1), verbose=TRUE)

# print the model details
posterior_interval(rlgt_model)
}
