
<!-- README.md is generated from README.Rmd. Please edit that file -->

<!-- badges: start -->

[![R-CMD-check](https://github.com/maelstrom-research/Rmonize/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/maelstrom-research/Rmonize/actions/workflows/R-CMD-check.yaml)
<!-- badges: end -->

<div style="display: flex; align-items: center; margin-bottom: 20px">

<img src="man/figures/fig_logo.png" style="width: 20%; height: auto; margin-right: 20px"/>
<span style="font-weight: bold; font-size: 24px;">Tools for Data
Harmonization</span>

</div>

Harmonizing data (achieving or improving inferential equivalence of data
collected by separate studies) can be required in epidemiological
research but is methodologically and technically challenging. Data
collected by separate studies are typically heterogenous, and decisions
on if and how to process data must be made, executed accurately, and
documented in a transparent manner. Rmonize is an R package developed by
<a href="https://www.maelstrom-research.org/" target="_blank">Maelstrom
Research</a> to address some of the key challenges in this process and
facilitate streamlined, reusable, and well documented harmonization
pipelines.

<div style="display: flex; align-items: center;">

<div style="flex: 0 0 auto; margin-right: 20px;">

<img src="man/figures/fig_1.png" style="width: 80px;">

</div>

<div style="flex: 1;">

Get an overview of processing with Rmonize and links to resources
available for each step on the
[Process](https://maelstrom-research.github.io/Rmonize-documentation/process/index.html)
page.

</div>

</div>

<div style="display: flex; align-items: center;">

<div style="flex: 0 0 auto; margin-right: 20px;">

<img src="man/figures/fig_2.png" style="width: 80px;">

</div>

<div style="flex: 1;">

For a quick start to using the package, see the vignettes [Install your
working
environment](https://maelstrom-research.github.io/Rmonize-documentation/articles/a-install-your-working-environment.html)
and a [Simple example of data processing with
Rmonize](https://maelstrom-research.github.io/Rmonize-documentation/articles/b-simple-example-of-data-processing-with-Rmonize.html).

</div>

</div>

<div style="display: flex; align-items: center;">

<div style="flex: 0 0 auto; margin-right: 20px;">

<img src="man/figures/fig_3.png" style="width: 80px;">

</div>

<div style="flex: 1;">

The
[Glossary](https://maelstrom-research.github.io/Rmonize-documentation/glossary/index.html)
provides information about package terminology, and the
[Functions](https://maelstrom-research.github.io/Rmonize-documentation/reference/index.html)
page provides technical documentation on package functions and built-in
materials.

</div>

</div>
