% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genr8.R
\name{genr8}
\alias{genr8}
\title{Simplify the the generation from a multivariate normal distributions.}
\usage{
genr8(n = 1, R = diag(10), mean = rep(0, ncol(R)), ...)
}
\arguments{
\item{n}{the number of samples required.}

\item{R}{a positive-definite symmetric matrix specifying the covariance matrix of the variables.}

\item{mean}{an optinal vector giving the means of the variables. Default is 0.}

\item{...}{arguments for \code{MASS::mvrnorm()}, such as \code{tol}, \code{empirical}, and \code{EISPACK}.}
}
\value{
A data frame of size \code{n} by \code{ncol(R)}.
}
\description{
Speed up the use of \code{MASS::mvrnorm}.
}
\examples{
set.seed(19)
R <- caron2016$mat1
mydata <- genr8(n = nrow(R)+1, R = R, empirical = TRUE)
round(mydata, 2)
round(cov(mydata), 2)
}
