% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{h_prep_survival_input}
\alias{h_prep_survival_input}
\title{Prepare Survival Input}
\usage{
h_prep_survival_input(formula, data, treatment)
}
\arguments{
\item{formula}{(\code{formula}) with a left hand side of the form \code{Surv(time, status)} and a right hand side
defining optional covariates or just \code{1} if there are no covariates.}

\item{data}{(\code{data.frame}) containing the variables in the formula.}

\item{treatment}{(\code{string} or \code{formula}) string name of the treatment, or a formula.}
}
\value{
A list containing the following elements:
\itemize{
\item \code{data}: The potentially updated data set.
\item \code{time}: Name of the time variable.
\item \code{status}: Name of the status variable.
\item \code{treatment}: Name of the treatment variable.
\item \code{strata}: Name of the strata variable.
\item \code{schema}: Randomization schema.
\item \code{covariates}: Names of the covariates in the model.
\item \code{model}: A formula only including the covariates, but not treatment or strata variables.
\item \code{n_levels}: Number of treatment levels.
\item \code{levels}: Names of the treatment levels.
}
}
\description{
Prepare Survival Input
}
\details{
Note that \code{formula} can also contain an externally defined \link[survival:Surv]{survival::Surv}
object. In this case, the \code{time} and \code{status} variables are extracted
and added to the \code{data} input. Note that it is up to the user to ensure that in this
case the column binding is correct, i.e., that the rows of the \code{data} match
with the rows of the \code{Surv} object. In addition, the same named variables must not appear
in both the \code{data} and the \code{Surv} object, to avoid ambiguity (this is a difference
vs. the behavior of \code{\link[survival:coxph]{survival::coxph()}} for better transparency).
}
\keyword{internal}
