% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformation.R
\name{transformations}
\alias{transformations}
\alias{mic_men}
\alias{run_transformations}
\title{Michaelis-Menten Transformation}
\usage{
mic_men(x, Vmax, Km, reverse = FALSE)

run_transformations(
  all_media,
  window_start_loc,
  window_end_loc,
  dt_mod,
  adstock,
  dt_hyppar,
  ...
)
}
\arguments{
\item{x}{Numeric value or vector. Input media spend when
\code{reverse = FALSE}. Input media exposure metrics (impression, clicks,
GRPs, etc.) when \code{reverse = TRUE}.}

\item{Vmax}{Numeric Indicates maximum rate achieved by the system.}

\item{Km}{Numeric. The Michaelis constant.}

\item{reverse}{Boolean. Input media spend when \code{reverse = FALSE}.
Input media exposure metrics (impression, clicks, GRPs etc.) when \code{reverse = TRUE}.}

\item{all_media}{Character. Vector of all selected paid media variable names.}

\item{window_start_loc}{Integer. Rolling window start location.}

\item{window_end_loc}{Integer. Rolling window end location.}

\item{dt_mod}{dataframe. Transformed input table for transformation.}

\item{adstock}{Character. Adstock config.}

\item{dt_hyppar}{data.frame. All hyperparaters for provided media.}

\item{...}{Additional parameters passed to \code{prophet} functions.}
}
\value{
Numeric values. Transformed values.
}
\description{
The Michaelis-Menten \code{mic_men()} function is used to fit the spend
exposure relationship for paid media variables, when exposure metrics like
impressions, clicks or GRPs are provided in \code{paid_media_vars} instead
of spend metric.
}
\examples{
mic_men(x = 5:10, Vmax = 5, Km = 0.5)
}
\seealso{
Other Transformations: 
\code{\link{adstock_geometric}()},
\code{\link{saturation_hill}()}
}
\concept{Transformations}
