% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameter_labels.R
\name{parameter_labels}
\alias{parameter_labels}
\alias{create_labels_s}
\alias{create_labels_alpha}
\alias{create_labels_b}
\alias{create_labels_Omega}
\alias{create_labels_Sigma}
\alias{create_labels_d}
\title{Create parameters labels}
\usage{
parameter_labels(
  P_f,
  P_r,
  J,
  C,
  cov_sym,
  ordered = FALSE,
  keep_par = c("s", "alpha", "b", "Omega", "Sigma", "d"),
  drop_par = NULL
)

create_labels_s(P_r, C)

create_labels_alpha(P_f)

create_labels_b(P_r, C)

create_labels_Omega(P_r, C, cov_sym)

create_labels_Sigma(J, cov_sym, ordered = FALSE)

create_labels_d(J, ordered)
}
\arguments{
\item{P_f}{[\code{integer(1)}]\cr
The number of covariates connected to a fixed coefficient.}

\item{P_r}{[\code{integer(2)}]\cr
The number of covariates connected to a random coefficient.}

\item{J}{[\code{integer(1)}]\cr
The number >= 2 of choice alternatives.}

\item{cov_sym}{Set to \code{TRUE} for labels of symmetric covariance elements.}

\item{ordered}{[\code{logical(1)}]\cr
If \code{TRUE}, the choice set \code{alternatives} is assumed to be ordered
from worst to best.}

\item{keep_par, drop_par}{A vector of parameter names which are kept or dropped.}
}
\value{
A list of labels for the selected model parameters.
}
\description{
This function creates model parameter labels.
}
\keyword{internal}
