% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ralaplace}
\alias{ralaplace}
\title{Generates an Asymmetric Laplace-distributed sample}
\usage{
ralaplace(n, m = 0, al = 1, ar = 1)
}
\arguments{
\item{n}{(int) - the size of the sample.}

\item{m}{(numeric) - the location parameter.}

\item{al, ar}{(numeric) - left and right scale parameters, respectively.}
}
\value{
a numeric vector containing a random sample.
}
\description{
Returns a sample from an Asymmetric Laplace distribution.
}
\details{
The Asymmetric Laplace distribution is given by the two-sided exponential
distribution given by the function:
\deqn{f(x;a_l,a_r,m) =
\frac{1}{A} e^{-|\frac{x-m}{a_l}| }, x < m
}
\deqn{f(x;a_l,a_r,m) =
\frac{1}{A} e^{-|\frac{x-m}{a_r}| }, x > m
}
with:
\deqn{A = a_l + a_r}
The random sampling is done by inverse transform sampling.
}
\examples{
sample_gamma <- ralaplace(1000)
}
