% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eva_functions.R
\name{declustpeaks}
\alias{declustpeaks}
\title{declustpeaks}
\usage{
declustpeaks(data, minpeakdistance = 10, minrundistance = 7, qt)
}
\arguments{
\item{data}{A numeric vector representing the data.}

\item{minpeakdistance}{An integer specifying the minimum distance between peaks.}

\item{minrundistance}{An integer specifying the minimum distance between runs.}

\item{qt}{A numeric value representing the threshold for peak detection.}
}
\value{
A data frame with information about the peaks, including:
\describe{
\item{\code{Q}}{the peak value}
\item{\code{max}}{max time index}
\item{\code{start}}{start time index}
\item{\code{end}}{end time index}
\item{\code{dur}}{duration}
\item{\code{cluster}}{cluster information }
}
}
\description{
\code{declustpeaks} is a function that takes in a data vector, minimum peak distance, minimum run distance, and a threshold value.
It finds peaks in the data vector based on the minimum peak distance and threshold value.
It then declusters the peaks based on the minimum run distance and threshold value.
The function returns a data frame with information about the peaks, including the peak value,
start and end indices, duration, and cluster information.
}
\examples{
data <- c(1, 2, 3, 4, 5, 4, 3, 2, 1)
declustpeaks(data, minpeakdistance = 2, minrundistance = 2, qt = 3)

}
