% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/country_from_coords.R
\name{country_from_coords}
\alias{country_from_coords}
\title{Extract country from coordinates}
\usage{
country_from_coords(
  occ,
  long = "decimalLongitude",
  lat = "decimalLatitude",
  country_column = NULL,
  from = "all",
  output_column = "country_xy",
  append_source = FALSE
)
}
\arguments{
\item{occ}{(data.frame) a dataset with occurrence records, preferably
standardized using \code{format_columns()}.}

\item{long}{(character) column name with longitude. Default is
'decimalLongitude'.}

\item{lat}{(character) column name with latitude. Default is
'decimalLatitude'.}

\item{country_column}{(character) the column name containing the country.
Only applicable if \code{from = na_only}. Default is NULL.}

\item{from}{(character) whether to extract the country for all records ('all')
or only for records missing country information ('na_only'). If 'na_only',
you must provide the name of the column with country information. Default is
'all'.}

\item{output_column}{(character) column name created in \code{occ} to store the
countries extracted. Default is 'country_xy'.}

\item{append_source}{(logical) whether to create a new column in \code{occ} called
'country_source', which indicates whether the country was derived from
coordinates. Default is FALSE.}
}
\value{
The original \code{occ} data.frame with an additional column containing the
countries extracted from coordinates.
}
\description{
Extracts the country for each occurrence record based on coordinates.
}
\details{
The countries are extracted from coordinates using a map retrieved from
\code{rnaturalearthdata::map_units110}.
}
\examples{
# Import and standardize GBIF
data("occ_gbif", package = "RuHere") #Import data example
gbif_standardized <- format_columns(occ_gbif, metadata = "gbif")
gbif_countries <- country_from_coords(occ = gbif_standardized)
}
