% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_timestamp.R
\name{db_timestamp}
\alias{db_timestamp}
\title{Determine the type of timestamps the database supports}
\usage{
db_timestamp(timestamp, conn = NULL)
}
\arguments{
\item{timestamp}{(\code{POSIXct(1)} or \code{character(1)})\cr
The timestamp to be transformed to the database type.}

\item{conn}{(\code{DBIConnection(1)})\cr
Connection object.}
}
\value{
The given timestamp converted to a SQL-backend dependent timestamp.
}
\description{
Determine the type of timestamps the database supports
}
\examples{
\dontshow{if (requireNamespace("RSQLite", quietly = TRUE)) withAutoprint(\{ # examplesIf}
  conn <- get_connection()

  db_timestamp(Sys.time(), conn)

  close_connection(conn)
\dontshow{\}) # examplesIf}
}
