% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{defer_db_cleanup}
\alias{defer_db_cleanup}
\title{Delete table at function exit}
\usage{
defer_db_cleanup(db_table)
}
\arguments{
\item{db_table}{(\code{tbl_sql})\cr
A unmanipulated reference to a sql table.}
}
\value{
NULL (called for side effects)
}
\description{
This function marks a table for deletion once the current function exits.
}
\examples{
\dontshow{if (requireNamespace("RSQLite", quietly = TRUE)) withAutoprint(\{ # examplesIf}
  conn <- get_connection()

  mt <- dplyr::copy_to(conn, mtcars)
  id_mt <- id(mt)

  defer_db_cleanup(mt)

  DBI::dbExistsTable(conn, id_mt) # TRUE

  withr::deferred_run()

  DBI::dbExistsTable(conn, id_mt) # FALSE

  close_connection(conn)
\dontshow{\}) # examplesIf}
}
