% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\name{plotOOB}
\alias{plotOOB}
\title{Visualize the out-of-bag performance of an SDForest}
\usage{
plotOOB(object, sqrt_scale = FALSE)
}
\arguments{
\item{object}{A paths object with loss_path \code{matrix} 
with the out-of-bag performance for each complexity parameter.}

\item{sqrt_scale}{If TRUE the x-axis is on a square root scale.}
}
\value{
A ggplot object
}
\description{
This function visualizes the out-of-bag performance of an SDForest
for different complexity parameters. Can be used to choose the optimal
complexity parameter.
}
\examples{
set.seed(1)
n <- 10
X <- matrix(rnorm(n * 5), nrow = n)
y <- sign(X[, 1]) * 3 + sign(X[, 2]) + rnorm(n)
model <- SDForest(x = X, y = y, Q_type = 'no_deconfounding', cp = 0.5)
paths <- regPath(model)
plotOOB(paths)
}
\seealso{
\code{\link{regPath.SDForest}}
}
\author{
Markus Ulmer
}
