% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/targetF.R
\name{targetF}
\alias{targetF}
\title{Computation of target F ('constant correlation model').}
\usage{
targetF(x, genegroups)
}
\arguments{
\item{x}{A \eqn{n \times p}{n x p} data matrix.}

\item{genegroups}{The genegroups are not used for this target.}
}
\value{
A \eqn{p \times p}{p x p} matrix.
}
\description{
The \eqn{p \times p}{p x p} target F is computed from the \eqn{n \times p}{n
x p} data matrix. It is defined as follows (\eqn{i,j = 1,...,p}{i,j =
1,...,p}): 
\deqn{
  t_{ij} = \begin{cases} 
   s_{ii} & \text{ if } i=j \\
   \bar{r}\sqrt{s_{ii}s_{jj} \text{ otherwise }}& 
  \end{cases}
}
where \eqn{\bar{r}}{r} is the average of
sample correlations and \eqn{s_{ij}}{sij} denotes the entry of the unbiased
covariance matrix in row \eqn{i}{i}, column \eqn{j}{j}.
}
\examples{

# A short example on a toy dataset
# require(SHIP)
data(expl)
attach(expl)
tar <- targetF(x,NULL)
which(tar[upper.tri(tar)]!=0) # many non zero coefficients !

}
\references{
J. Schaefer and K. Strimmer, 2005. A shrinkage approach to
large-scale covariance matrix estimation and implications for functional
genomics.  Statist. Appl. Genet. Mol. Biol. 4:32.
}
\seealso{
\code{\link{targetCor}}, \code{\link{targetF}},
\code{\link{targetG}}, \code{\link{targetGstar}}, \code{\link{targetGpos}}.
}
\author{
Monika Jelizarow and Vincent Guillemot
}
\keyword{methods}
\keyword{multivariate}
