% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_SelfSpectra2dB}
\alias{seasonder_SelfSpectra2dB}
\title{Convert Self-Spectra to dB Using a SeaSondeR Object}
\usage{
seasonder_SelfSpectra2dB(seasonder_cs_object, spectrum_values)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeR} cross-spectral object.}

\item{spectrum_values}{A numeric vector. The power values in linear scale.}
}
\value{
A numeric vector of power values in decibels (dB).
}
\description{
This function transforms self-spectra power values into decibels (dB) by retrieving the receiver gain from a given \code{SeaSondeR} object.
}
\details{
This function first extracts the receiver gain in decibels from the \code{seasonder_cs_object} using \code{\link{seasonder_getReceiverGain_dB}} and then applies the conversion using:
\deqn{dB = 10 \log_{10}(|P|) - G}
where:
\itemize{
\item \( dB \) is the power in decibels,
\item \( P \) is the self-spectra power in linear scale,
\item \( G \) is the receiver gain in decibels.
}

This function ensures consistency by obtaining the receiver gain directly from the \code{SeaSondeR} object.
}
\seealso{
\code{\link{self_spectra_to_dB}} for a generic power-to-dB transformation.
}
