% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{AddChromatinModule}
\alias{AddChromatinModule}
\title{Add chromatin module}
\usage{
AddChromatinModule(object, features, genome, assay = NULL, verbose = TRUE, ...)
}
\arguments{
\item{object}{A Seurat object}

\item{features}{A named list of features to include in each module. The name
of each element in the list will be used to name the modules computed, which
will be stored in the object metadata.}

\item{genome}{A BSgenome object}

\item{assay}{Name of assay to use. If NULL, use the default assay.}

\item{verbose}{Display messages}

\item{...}{Additional arguments passed to \code{RunChromVAR}}
}
\value{
Returns a Seurat object
}
\description{
Compute chromVAR deviations for groups of peaks. The goal of this function is
similar to that of \code{\link[Seurat]{AddModuleScore}} except that it is
designed for single-cell chromatin data. The chromVAR deviations for each
group of peaks will be added to the object metadata.
}
\concept{utilities}
