% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save.R
\name{saveFiles}
\alias{saveFiles}
\title{Save objects using \code{.saveObjects} in \code{params} slot of \code{simInit}}
\usage{
saveFiles(sim)
}
\arguments{
\item{sim}{A \code{simList} simulation object.}
}
\value{
(invisibly) the modified \code{sim} object.
invoked for side effect of saving the simulation to file.
}
\description{
In the \code{\link[=simInit]{simInit()}} call, a parameter called \code{.saveObjects} can be provided in
each module.
This must be a character string vector of all object names to save. These objects will
then be saved whenever a call to \code{saveFiles} is made.
}
\details{
The file names will be equal to the object name plus \code{time(sim)} is
appended at the end.
The files are saved as \code{.rds} files, meaning, only one object gets
saved per file.

For objects saved using this function, the module developer must create save
events that schedule a call to \code{saveFiles}.

If this function is used outside of a module, it will save all files in the
\code{outputs(sim)} that are scheduled to be saved at the current time in the \code{simList.}

There are several ways to save objects using \code{SpaDES}.
}
\note{
It is not possible to schedule separate saving events for each object
that is listed in the \code{.saveObjects}.
}
\section{Model-level saving}{


Using the \code{outputs} slot in the \code{\link[=simInit]{simInit()}} call.
See example in \code{\link[=simInit]{simInit()}}.
This can be convenient because it gives overall control of many modules at a
time, and it gets automatically scheduled during the \code{\link[=simInit]{simInit()}} call.
}

\section{Module-level saving}{


Using the \code{saveFiles} function inside a module.
This must be accompanied by a \code{.saveObjects} vector or list element in the
\code{params} slot in the \code{\link[=simList]{simList()}}.
Usually a module developer will create this method for future users of their module.
}

\section{Custom saving}{


A module developer can save any object at any time inside their module, using
standard R functions for saving R objects (e.g., \code{save} or \code{saveRDS}).
This is the least modular approach, as it will happen whether a module user
wants it or not.
}

\examples{
\donttest{
if (requireNamespace("SpaDES.tools", quietly = TRUE) &&
      packageVersion("SpaDES.tools") > "3.0.0") {
## This will save the "caribou" object at the save interval of 1 unit of time
## in the outputPath location
  outputPath <- file.path(tempdir(), "test_save")
  times <- list(start = 0, end = 1, "month")

  modules <- list("randomLandscapes", "caribouMovement")
  paths <- list(
    modulePath = getSampleModules(tempdir()),
    outputPath = outputPath
  )
 opts <- options("spades.moduleCodeChecks" = FALSE,
                 "spades.useRequire" = FALSE) # not necessary for example

  ## save multiple outputs
  parameters <- list(
    .globals = list(stackName = "landscape"),
    caribouMovement = list(
      .saveObjects = c("caribou", "habitatQuality"),
      .saveInitialTime = 1, .saveInterval = 1
    ),
    randomLandscapes = list(.plots = NA, nx = 20, ny = 20))

  mySim <- simInit(times = times, params = parameters, modules = modules,
                 paths = paths)

  spades(mySim, .plotInitialTime = NA) # plotting not relevant for this example
  dir(outputPath)
  # remove the files
  file.remove(dir(outputPath, full.names = TRUE))

  options(opts) # clean up
}}
}
\author{
Eliot McIntire and Alex Chubaty
}
