% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R, R/save.R
\name{.fileExtensions}
\alias{.fileExtensions}
\alias{loadFiles}
\alias{loadFiles,simList,missing-method}
\alias{loadFiles,missing,ANY-method}
\alias{loadFiles,missing,missing-method}
\alias{.saveFileExtensions}
\title{File extensions map}
\usage{
.fileExtensions()

loadFiles(sim, filelist, ...)

\S4method{loadFiles}{simList,missing}(sim, filelist, ...)

\S4method{loadFiles}{missing,ANY}(sim, filelist, ...)

\S4method{loadFiles}{missing,missing}(sim, filelist, ...)

.saveFileExtensions()
}
\arguments{
\item{sim}{\code{simList} object.}

\item{filelist}{\code{list} or \code{data.frame} to call \code{loadFiles} directly from the
\code{filelist} as described in Details}

\item{...}{Additional arguments.}
}
\value{
\code{data.frame} of file extension, package, and function mappings

the modified \code{sim}, invisibly.

\code{data.frame}
}
\description{
How to load various types of files in R.

This function has two roles:
\enumerate{
\item to proceed with the loading of files that are in a \code{simList}; or
\item as a shortcut to \code{simInit(inputs = filelist)}.
}

A \code{data.frame} with information on how to load various types of files in R,
containing the columns:
\itemize{
\item \code{exts}: the file extension;
\item \code{fun}: the function to use for files with this file extension;
\item \code{package}: the package from which to load \code{fun}.
}
}
\note{
Generally not intended to be used by users.
}
\examples{
\donttest{
library(SpaDES.core)

# Load random maps included with package
filelist <- data.frame(
  files = dir(getMapPath(tempdir()), full.names = TRUE),
  functions = "rasterToMemory",
  package = "SpaDES.core"
)
sim1 <- loadFiles(filelist = filelist) # loads all the maps to sim1 simList

# Second, more sophisticated. All maps loaded at time = 0, and the last one is reloaded
#  at time = 10 and 20 (via "intervals").
# Also, pass the single argument as a list to all functions...
#  specifically, when add "native = TRUE" as an argument to the raster function
files <- dir(getMapPath(tempdir()), full.names = TRUE)
arguments <- I(rep(list(lyrs = 1), length(files)))
filelist <- data.frame(
   files = files,
   functions = "terra::rast",
   objectName = NA,
   arguments = arguments,
   loadTime = 0,
   intervals = c(rep(NA, length(files)-1), 10)
)

sim2 <- loadFiles(filelist = filelist) # only does the time = 0 loading; see next
end(sim2) <- 10
sim2 <- spades(sim2) # loads the object at time 10

# if we extend the end time and continue running, it will load an object scheduled
#  at time = 10, and it will also schedule a new object loading at 20 because
#  interval = 10
end(sim2) <- 20
sim2 <- spades(sim2) # loads the percentPine map 2 more times, once at 10, once at 20
}
}
\seealso{
\code{\link[=inputs]{inputs()}}
}
\author{
Eliot McIntire and Alex Chubaty
}
