% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sporulation_gene_name.R
\name{sporulation_gene_name}
\alias{sporulation_gene_name}
\title{Identify Sporulation-Associated Genes}
\usage{
sporulation_gene_name(df)
}
\arguments{
\item{df}{A data frame containing MAG annotation with the columns 'Preferred_name', 'KEGG_ko', and 'genome_ID'.}
}
\value{
A data frame of sporulation-associated genes with standardized names and spo_process tags.
}
\description{
This function identifies sporulation-associated genes in a genome annotation data frame.
It searches for gene names and KEGG Orthology identifiers related to sporulation steps and returns
a data frame with annotated sporulation genes and a consensus name.
}
\examples{

# Load package
library(SpoMAG)
# Load example annotation tables
file_spor <- system.file("extdata", "one_sporulating.csv.gz", package = "SpoMAG")
file_aspo <- system.file("extdata", "one_asporogenic.csv.gz", package = "SpoMAG")

# Read files
df_spor <- readr::read_csv(file_spor, show_col_types = FALSE)
df_aspo <- readr::read_csv(file_aspo, show_col_types = FALSE)

# Step 1: Extract sporulation-related genes
genes_spor <- sporulation_gene_name(df_spor)
genes_aspo <- sporulation_gene_name(df_aspo)

}
