% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overall_trend.R
\name{overall_trend}
\alias{overall_trend}
\title{Overall trend analysis}
\usage{
overall_trend(data, predictor, responses)
}
\arguments{
\item{data}{A \verb{data frame} containing the variables for the model, including \code{species}, \code{year}, \code{month}, \code{lon}, \code{lat}, \code{tme} and \code{ele}.}

\item{predictor}{A \code{character}vector of predictor variable names representing a temporal variable (\code{year_month}).}

\item{responses}{A \code{character} vector of response variable names to analyze.}
}
\value{
A data frame with trend statistics, including:
\itemize{
\item \code{responses}: The name of the variable analyzed.
\item \code{trend}: Slope of the linear model (rate of change over time).
\item \code{t}: t-statistic of the model.
\item \code{pvalue}: Statistical significance of the overall trend.
\item \code{ci_95_max}, \code{ci_95_min}: 95\\% confidence interval bounds for the slope.
\item \code{n}: Sample size for the specific species/hemisphere subset
\item \code{hemisphere}: Geographic context (\code{North}, \code{South}, or \code{Both} for global comparison).
}
}
\description{
Calculates the overall temporal trend (OT) of selected response variables across the entire dataset.
This trend integrates both environmental change and the cumulative effects of sampling bias, and serves as a neutral reference against which species-specific temporal trends are evaluated.
}
\details{
Longitude (\code{lon}) values are transformed to a 0-360 range to ensure statistical consistency near the antimeridian.
A key feature of this function is its specialized handling of latitude. Because the Equator is set at 0, latitude values in the Southern Hemisphere are negative.
To ensure that a direction shift is interpreted consistently across the globe (where a negative increase in the South corresponds to a positive increase in the North), the function employs two complementary approaches:
Hemispheric split: It divides the records based on their location (\code{lat < 0} for \code{South} and \code{lat > 0} for \code{North}) and performs separate analyses for each.
Global analysis: It performs an analysis using the complete dataset (\code{Global}) by transforming all latitudes into absolute values (\code{abs(lat)}). This allows for a unified global trend estimation.
Note that this hemispheric division and absolute transformation logic is applied exclusively to the latitude (\code{lat}) variable.
}
\examples{

data <- data.frame(
   species = sample(paste0("spp_", 1:10), 500, replace = TRUE),
   year = sample(1950:2020, 500, replace = TRUE),
   month = sample(1:12, 500, replace = TRUE),
   lon = runif(500, -10, 20),
   lat = runif(500, 30, 70),
   tme = rnorm(500, 15, 10)
)

data$year_month <- data$year + data$month * 0.075

predictor <- "year_month"
responses <- c("lat", "lon", "tme")

overall_trend_result <- overall_trend(data, predictor, responses)

print(overall_trend_result)

}
