% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_param_xml.R
\name{set_param_xml}
\alias{set_param_xml}
\title{Setting parameter values into xml files}
\usage{
set_param_xml(
  file,
  param,
  values,
  save_as = NULL,
  select = NULL,
  select_value = NULL,
  value_id = NULL,
  overwrite = FALSE,
  xml_file = lifecycle::deprecated(),
  out_path = lifecycle::deprecated(),
  param_name = lifecycle::deprecated(),
  param_value = lifecycle::deprecated(),
  value = lifecycle::deprecated(),
  ...
)
}
\arguments{
\item{file}{Path (including name) of the xml file to modify}

\item{param}{Vector of parameter names.}

\item{values}{A vector or a list of parameter(s) values (see details).}

\item{save_as}{Path (including name) of the xml file to generate.
Optional, if NULL \code{file} is overwritten.}

\item{select}{node name or attribute name to use for selection
(optional, default to no selection)}

\item{select_value}{Vector of values used for select (see examples).
Optional, should be provided only if select is provided.}

\item{value_id}{Vector of ids of the parameters values to be retrieved
from the parameter values vector}

\item{overwrite}{Logical TRUE for overwriting the output file,
FALSE otherwise (default)}

\item{xml_file}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{xml_file} is no
longer supported, use file instead.}

\item{out_path}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{out_path} is no
longer supported, use save_as instead.}

\item{param_name}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{param_name} is no
longer supported, use param instead.}

\item{param_value}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{param_value} is no
longer supported, use values instead.}

\item{value}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{value} is no
longer supported, use select_value instead.}

\item{...}{Pass further arguments to \code{set_param_value()}.}
}
\value{
A logical value TRUE for operation success, FALSE otherwise
}
\description{
Setting parameter values for a parameter or a vector of and
with a parameters values vector
}
\details{
It is possible to give several values for a parameter by passing
a vector of values. For example, for two parameters with two values each:
value= list(c(1,2), c(2.3,4.5))
}
\examples{

ex_path <- get_examples_path(file_type = "xml")

# Soil file

sol_path <- file.path(ex_path, "sols.xml")

# For scalar parameters per soil
# Setting all soils "argi" values to 50
set_param_xml(sol_path, "argi", 50, overwrite = TRUE)
# Getting changed values
# get_param_xml(sol_path, "argi")

# Setting a specific value to "argi" for "solcanne" soil
set_param_xml(
  file = sol_path, param = "argi", values = 56,
  select = "sol", select_value = "solcanne", overwrite = TRUE
)
# Getting changed values
# get_param_xml(sol_path, "argi",
#   select = "sol", select_value = "solcanne"
# )


# Setting a specific values to 2 parameters "argi" and
# "norg" for "solcanne" soil
set_param_xml(sol_path, c("argi", "norg"), list(100, 150),
  select = "sol", select_value = "solcanne", overwrite = TRUE
)
# Getting changed values
# get_param_xml(sol_path, c("argi", "norg"),
#   select = "sol", select_value = "solcanne"
# )


# For vector parameters per soil (5 values, one per soil layer)
set_param_xml(sol_path, c("epc", "HCCF"),
  select = "sol",
  select_value = c("solcanne", "solbanane"),
  values = list(c(20:24, 10:14), c(50:54, 40:44)),
  overwrite = TRUE
)

# Getting changed values
# get_param_xml(sol_path, c("epc", "HCCF"),
# select = "sol",
# select_value = c("solcanne", "solbanane")
# )

# For specific values of vector parameters
set_param_xml(sol_path, "HCCF",
  select = "sol",
  select_value = "solcanne",
  values = c(46.8, 48.5, 50.1),
  value_id = c(1, 3, 5),
  overwrite = TRUE
)

# Getting changed values
# get_param_xml(sol_path, "HCCF",
# select = "sol",
# select_value = "solcanne",
# value_id = c(1,3,5)
# )

# Crop management file

tec_path <- file.path(ex_path, "file_tec.xml")

# Modifying irrigations parameters
set_param_xml(tec_path, c("julapI_or_sum_upvt", "amount"),
  values = list(200:215, 20:35), overwrite = TRUE
)
# Getting changed values
# get_param_xml(tec_path, c("julapI_or_sum_upvt", "amount"))

}
