# C1 test boot

ICAtestGauss_jade <- function(X, n.boot = 200 , eps = 1e-06, maxiter = 100)
{
  ICA <- JADE(X, eps = eps, maxiter=maxiter)
  T.W <- TmW_Gauss(ICA$S)
  Tboot <- replicate(n.boot, TmW_Gauss(bootZjade(ICA$S, eps = eps, maxiter=maxiter)))
  PVAL <- (sum(T.W < Tboot) +  1)/(n.boot + 1)
  RES  <- list(T=T.W, Tboot = Tboot, pval=PVAL, ICA=ICA)
  RES
}

ICAtestGauss_fobi <- function(X, n.boot = 200)
{
  ICA <- FOBI(X)
  T.W <- TmW_Gauss(ICA$S)
  Tboot <- replicate(n.boot, TmW_Gauss(bootZfobi(ICA$S)))
  PVAL <- (sum(T.W < Tboot) +  1)/(n.boot + 1)
  RES  <- list(T=T.W, Tboot = Tboot, pval=PVAL, ICA=ICA)
  RES
}

ICAtestGauss_fICA <- function(X, n.boot = 200, g = "tanh", method = "sym", inR = FALSE, maxiter = 500, eps=1e-06, n.init=2)
{
  ICA <- fICA(X, g = g, method = method, inR = inR, maxiter = maxiter, n.init=n.init, eps=eps)
  T.W <- TmW_Gauss(ICA$S)
  Tboot <- replicate(n.boot, TmW_Gauss(bootZfICA(ICA$S, g = g, method = method, inR = inR, maxiter = maxiter, n.init=n.init, eps=eps)))
  PVAL <- (sum(T.W < Tboot) +  1)/(n.boot + 1)
  RES  <- list(T=T.W, Tboot = Tboot, pval=PVAL, ICA=ICA)
  RES
}

ICAtestGauss_S <- function(X, n.boot = 200)
{
  S <- scale(X)
  T.W <- TmW_Gauss(S)
  Tboot <- replicate(n.boot, TmW_Gauss(scale(bootS(S))))
  PVAL <- (sum(T.W < Tboot) +  1)/(n.boot + 1)
  RES  <- list(T=T.W, Tboot = Tboot, pval=PVAL)
  RES
}

# C2 Test boot

ICAtestLap_jade <- function(X, n.boot = 200, eps = 1e-06, maxiter = 100)
{
  ICA <- JADE(X, eps = eps, maxiter=maxiter)
  T.W <- TmW_Lap(ICA$S)
  Tboot <- replicate(n.boot, TmW_Lap(bootZjade(ICA$S, eps = eps, maxiter = maxiter)))
  PVAL <- (sum(T.W < Tboot) +  1)/(n.boot + 1)
  RES  <- list(T=T.W, Tboot = Tboot, pval=PVAL, ICA=ICA)
  RES
}

ICAtestLap_fobi <- function(X, n.boot = 200)
{
  ICA <- FOBI(X)
  T.W <- TmW_Lap(ICA$S)
  Tboot <- replicate(n.boot, TmW_Lap(bootZfobi(ICA$S)))
  PVAL <- (sum(T.W < Tboot) +  1)/(n.boot + 1)
  RES  <- list(T=T.W, Tboot = Tboot, pval=PVAL, ICA=ICA)
  RES
}

ICAtestLap_fICA <- function(X, n.boot = 200, g = "tanh", method = "sym", inR = FALSE, maxiter = 500, eps=1e-06, n.init=2)
{
  ICA <- fICA(X, g = g, method = method, inR = inR, maxiter = maxiter, n.init=n.init, eps=eps)
  T.W <- TmW_Lap(ICA$S)
  Tboot <- replicate(n.boot, TmW_Lap(bootZfICA(ICA$S, g = g, method = method, inR = inR, maxiter = maxiter, n.init=n.init, eps=eps)))
  PVAL <- (sum(T.W < Tboot) +  1)/(n.boot + 1)
  RES  <- list(T=T.W, Tboot = Tboot, pval=PVAL, ICA=ICA)
  RES
}

ICAtestLap_S <- function(X, n.boot = 200)
{
  S <- scale(X)
  T.W <- TmW_Lap(S)
  Tboot <- replicate(n.boot, TmW_Lap(scale(bootS(S))))
  PVAL <- (sum(T.W < Tboot) +  1)/(n.boot + 1)
  RES  <- list(T=T.W, Tboot = Tboot, pval=PVAL)
  RES
}


# C3 Rank Gauss boot

ICAtestRankGauss_jade <- function(X, n.boot = 200, eps = 1e-06, maxiter = 100)
{
  ICA <- JADE(X, eps = eps, maxiter=maxiter)
  n <- nrow(X)
  R <- RANKS(ICA$S)
  T.W <- TmW_Gauss(R)
  Tboot <- replicate(n.boot, TmW_Gauss(RANKS(bootZjade(ICA$S, eps = eps, maxiter = maxiter))))
  PVAL <- (sum(T.W < Tboot) +  1)/(n.boot + 1)
  RES  <- list(T=T.W, Tboot = Tboot, pval=PVAL, ICA=ICA)
  RES
}

ICAtestRankGauss_fobi <- function(X, n.boot = 200)
{
  ICA <- FOBI(X)
  R <- RANKS(ICA$S)
  T.W <- TmW_Gauss(R)
  Tboot <- replicate(n.boot, TmW_Gauss(RANKS(bootZfobi(ICA$S))))
  PVAL <- (sum(T.W < Tboot) +  1)/(n.boot + 1)
  RES  <- list(T=T.W, Tboot = Tboot, pval=PVAL, ICA=ICA)
  RES
}

ICAtestRankGauss_fICA <- function(X, n.boot = 200, g = "tanh", method = "sym", inR = FALSE, maxiter = 500, eps=1e-06, n.init=2)
{
  ICA <- fICA(X, g = g, method = method, inR = inR, maxiter = maxiter, n.init=n.init, eps=eps)
  R <- RANKS(ICA$S)
  T.W <- TmW_Gauss(R)
  Tboot <- replicate(n.boot, TmW_Gauss(RANKS(bootZfICA(ICA$S, g = g, method = method, inR = inR, maxiter = maxiter, n.init=n.init, eps=eps))))
  PVAL <- (sum(T.W < Tboot) +  1)/(n.boot + 1)
  RES  <- list(T=T.W, Tboot = Tboot, pval=PVAL, ICA=ICA)
  RES
}


ICAtestRankGauss_S <- function(X, n.boot = 200)
{
  S <- scale(X)
  R <- RANKS(S)
  T.W <- TmW_Gauss(R)
  Tboot <- replicate(n.boot, TmW_Gauss(RANKS(scale(bootS(S)))))
  PVAL <- (sum(T.W < Tboot) +  1)/(n.boot + 1)
  RES  <- list(T=T.W, Tboot = Tboot, pval=PVAL)
  RES
}





# C4 Rank Lap boot

ICAtestRankLap_jade <- function(X, n.boot = 200, eps = 1e-06, maxiter = 100)
{
  ICA <- JADE(X, eps = eps, maxiter=maxiter)
  n <- nrow(X)
  R <- RANKS(ICA$S)
  T.W <- TmW_Lap(R)
  Tboot <- replicate(n.boot, TmW_Lap(RANKS(bootZjade(ICA$S, eps = eps, maxiter = maxiter))))
  PVAL <- (sum(T.W < Tboot) +  1)/(n.boot + 1)
  RES  <- list(T=T.W, Tboot = Tboot, pval=PVAL, ICA=ICA)
  RES
}

ICAtestRankLap_fobi <- function(X, n.boot = 200)
{
  ICA <- FOBI(X)
  R <- RANKS(ICA$S)
  T.W <- TmW_Lap(R)
  Tboot <- replicate(n.boot, TmW_Lap(RANKS(bootZfobi(ICA$S))))
  PVAL <- (sum(T.W < Tboot) +  1)/(n.boot + 1)
  RES  <- list(T=T.W, Tboot = Tboot, pval=PVAL, ICA=ICA)
  RES
}

ICAtestRankLap_fICA <- function(X, n.boot = 200, g = "tanh", method = "sym", inR = FALSE, maxiter = 500, eps=1e-06, n.init=2)
{
  ICA <- fICA(X, g = g, method = method, inR = inR, maxiter = maxiter, n.init=n.init, eps=eps)
  R <- RANKS(ICA$S)
  T.W <- TmW_Lap(R)
  Tboot <- replicate(n.boot, TmW_Lap(RANKS(bootZfICA(ICA$S, g = g, method = method, inR = inR, maxiter = maxiter, n.init=n.init, eps=eps))))
  PVAL <- (sum(T.W < Tboot) +  1)/(n.boot + 1)
  RES  <- list(T=T.W, Tboot = Tboot, pval=PVAL, ICA=ICA)
  RES
}


ICAtestRankLap_S <- function(X, n.boot = 200)
{
  S <- scale(X)
  R <- RANKS(S)
  T.W <- TmW_Lap(R)
  Tboot <- replicate(n.boot, TmW_Lap(RANKS(scale(bootS(S)))))
  PVAL <- (sum(T.W < Tboot) +  1)/(n.boot + 1)
  RES  <- list(T=T.W, Tboot = Tboot, pval=PVAL)
  RES
}



# C5 vdw Gauss boot

ICAtestRankvdW_jade <- function(X, n.boot = 200, eps = 1e-06, maxiter = 100)
{
  ICA <- JADE(X, eps = eps, maxiter=maxiter)
  n <- nrow(X)
  R <- VdW(ICA$S)
  T.W <- TmW_Gauss(R)
  Tboot <- replicate(n.boot, TmW_Gauss(VdW(bootZjade(ICA$S, eps = eps, maxiter=maxiter))))
  PVAL <- (sum(T.W < Tboot) +  1)/(n.boot + 1)
  RES  <- list(T=T.W, Tboot = Tboot, pval=PVAL, ICA=ICA)
  RES
}

ICAtestRankvdW_fobi <- function(X, n.boot = 200)
{
  ICA <- FOBI(X)
  R <- VdW(ICA$S)
  T.W <- TmW_Gauss(R)
  Tboot <- replicate(n.boot, TmW_Gauss(VdW(bootZfobi(ICA$S))))
  PVAL <- (sum(T.W < Tboot) +  1)/(n.boot + 1)
  RES  <- list(T=T.W, Tboot = Tboot, pval=PVAL, ICA=ICA)
  RES
}

ICAtestRankvdW_fICA <- function(X, n.boot = 200, g = "tanh", method = "sym", inR = FALSE, maxiter = 500, eps=1e-06, n.init=2)
{
  ICA <- fICA(X, g = g, method = method, inR = inR, maxiter = maxiter, n.init=n.init, eps=eps)
  R <- VdW(ICA$S)
  T.W <- TmW_Gauss(R)
  Tboot <- replicate(n.boot, TmW_Gauss(VdW(bootZfICA(ICA$S, g = g, method = method, inR = inR, maxiter = maxiter, n.init=n.init, eps=eps))))
  PVAL <- (sum(T.W < Tboot) +  1)/(n.boot + 1)
  RES  <- list(T=T.W, Tboot = Tboot, pval=PVAL, ICA=ICA)
  RES
}


ICAtestRankvdW_S <- function(X, n.boot = 200)
{
  S <- scale(X)
  R <- VdW(S)
  T.W <- TmW_Gauss(R)
  Tboot <- replicate(n.boot, TmW_Gauss(VdW(scale(bootS(S)))))
  PVAL <- (sum(T.W < Tboot) +  1)/(n.boot + 1)
  RES  <- list(T=T.W, Tboot = Tboot, pval=PVAL)
  RES
}