ICAtestRankvdW_jade_perm_par <- function(X, n.perm = 200, eps = 1e-06, maxiter = 100, ncores = NULL, iseed = NULL) {
  ICA <- JADE(X, eps = eps, maxiter = maxiter)
  n <- nrow(X)
  T.W <- TmW_Gauss(VdW(ICA$S))
  
  # Set up parallel environment
  if (!is.null(ncores) && ncores > 1) {
    cl <- makeCluster(ncores, type = "PSOCK")
    clusterExport(cl, varlist = c("VdW", "permZjade", "TmW_Gauss", "ICA", "eps", "maxiter", "iseed"), envir = environment())
    clusterSetRNGStream(cl, iseed)
    
    # Using parSapply to run the permutations in parallel
    Tperm <- parSapply(cl, seq_len(n.perm), function(i) {
      TmW_Gauss(VdW(permZjade(ICA$S, eps = eps, maxiter = maxiter)))
    })
    stopCluster(cl)
  } else {
    # Fallback to non-parallel execution if no cores are specified
    Tperm <- replicate(n.perm, TmW_Gauss(VdW(permZjade(ICA$S, eps = eps, maxiter = maxiter))))
  }
  
  PVAL <- (sum(T.W < Tperm) + 1) / (n.perm + 1)
  RES <- list(T = T.W, Tperm = Tperm, pval = PVAL, ICA = ICA)
  return(RES)
}


ICAtestGauss_jade_perm_par <- function(X, n.perm = 200, eps = 1e-06, maxiter = 100, ncores = NULL, iseed = NULL) {
  ICA <- JADE(X, eps = eps, maxiter = maxiter)
  T.W <- TmW_Gauss(ICA$S)
  
  # Set up parallel environment if more than one core is specified
  if (!is.null(ncores) && ncores > 1) {
    cl <- makeCluster(ncores, type = "PSOCK")
    clusterExport(cl, varlist = c("TmW_Gauss", "permZjade", "ICA", "eps", "maxiter", "iseed"), envir = environment())
    clusterSetRNGStream(cl, iseed)
    
    # Using parSapply to run the permutations in parallel
    Tperm <- parSapply(cl, seq_len(n.perm), function(i) {
      TmW_Gauss(permZjade(ICA$S, eps = eps, maxiter = maxiter))
    })
    
    # Stop the cluster
    stopCluster(cl)
  } else {
    # Fallback to sequential processing if no cores are specified
    Tperm <- replicate(n.perm, TmW_Gauss(permZjade(ICA$S, eps = eps, maxiter = maxiter)))
  }
  
  # Calculate the p-value
  PVAL <- (sum(T.W < Tperm) + 1) / (n.perm + 1)
  
  # Return results
  RES <- list(T = T.W, Tperm = Tperm, pval = PVAL, ICA = ICA)
  return(RES)
}


ICAtestGauss_fobi_perm_par <- function(X, n.perm = 200, ncores = NULL, iseed = NULL) {
  # Perform FOBI on the original data
  ICA <- FOBI(X)
  T.W <- TmW_Gauss(ICA$S)
  
  # Set up parallel environment if more than one core is specified
  if (!is.null(ncores) && ncores > 1) {
    cl <- makeCluster(ncores, type = "PSOCK")
    # Export necessary variables and functions to the cluster
    clusterExport(cl, varlist = c("TmW_Gauss", "permZfobi", "ICA", "iseed"), envir = environment())
    clusterSetRNGStream(cl, iseed)  # Set RNG stream for reproducibility
    
    # Use parSapply to perform the permutations in parallel
    Tperm <- parSapply(cl, seq_len(n.perm), function(i) {
      TmW_Gauss(permZfobi(ICA$S))
    })
    
    # Stop the cluster after use
    stopCluster(cl)
  } else {
    # Fallback to sequential processing if no cores are specified
    Tperm <- replicate(n.perm, TmW_Gauss(permZfobi(ICA$S)))
  }
  
  # Calculate the p-value
  PVAL <- (sum(T.W < Tperm) + 1) / (n.perm + 1)
  
  # Return the results
  RES <- list(T = T.W, Tperm = Tperm, pval = PVAL, ICA = ICA)
  return(RES)
}


ICAtestGauss_fICA_perm_par <- function(X, n.perm = 200, g = "tanh", method = "sym", inR = FALSE, maxiter = 500, eps=1e-06, n.init=2, ncores = NULL, iseed = NULL) {
  # Perform FastICA on the original data
  ICA <- fICA(X, g = g, method = method, inR = inR, maxiter = maxiter, n.init = n.init, eps = eps)
  T.W <- TmW_Gauss(ICA$S)
  
  # Set up parallel environment if more than one core is specified
  if (!is.null(ncores) && ncores > 1) {
    cl <- makeCluster(ncores, type = "PSOCK")
    # Export necessary variables and functions to the cluster
    clusterExport(cl, varlist = c("TmW_Gauss", "permZfICA", "ICA", "g", "method", "inR", "maxiter", "n.init", "eps", "iseed"), envir = environment())
    clusterSetRNGStream(cl, iseed)  # Set RNG stream for reproducibility
    
    # Use parSapply to perform the permutations in parallel
    Tperm <- parSapply(cl, seq_len(n.perm), function(i) {
      TmW_Gauss(permZfICA(ICA$S, g = g, method = method, inR = inR, maxiter = maxiter, n.init = n.init, eps = eps))
    })
    
    # Stop the cluster after use
    stopCluster(cl)
  } else {
    # Fallback to sequential processing if no cores are specified
    Tperm <- replicate(n.perm, TmW_Gauss(permZfICA(ICA$S, g = g, method = method, inR = inR, maxiter = maxiter, n.init = n.init, eps = eps)))
  }
  
  # Calculate the p-value
  PVAL <- (sum(T.W < Tperm) + 1) / (n.perm + 1)
  
  # Return the results
  RES <- list(T = T.W, Tperm = Tperm, pval = PVAL, ICA = ICA)
  return(RES)
}


ICAtestGauss_S_perm_par <- function(X, n.perm = 200, ncores = NULL, iseed = NULL) {
  S <- scale(X)
  T.W <- TmW_Gauss(S)
  
  # Set up parallel environment if more than one core is specified
  if (!is.null(ncores) && ncores > 1) {
    cl <- makeCluster(ncores, type = "PSOCK")
    # Export necessary variables and functions to the cluster
    clusterExport(cl, varlist = c("TmW_Gauss", "permS", "S", "iseed"), envir = environment())
    clusterSetRNGStream(cl, iseed)  # Set RNG stream for reproducibility
    
    # Use parSapply to perform the permutations in parallel
    Tperm <- parSapply(cl, seq_len(n.perm), function(i) {
      TmW_Gauss(scale(permS(S)))
    })
    
    # Stop the cluster after use
    stopCluster(cl)
  } else {
    # Fallback to sequential processing if no cores are specified
    Tperm <- replicate(n.perm, TmW_Gauss(scale(permS(S))))
  }
  
  # Calculate the p-value
  PVAL <- (sum(T.W < Tperm) + 1) / (n.perm + 1)
  
  # Return the results
  RES <- list(T = T.W, Tperm = Tperm, pval = PVAL)
  return(RES)
}

ICAtestLap_jade_perm_par <- function(X, n.perm = 200, eps = 1e-06, maxiter = 100, ncores = NULL, iseed = NULL) {
  ICA <- JADE(X, eps = eps, maxiter = maxiter)
  T.W <- TmW_Lap(ICA$S)
  
  # Set up parallel environment if more than one core is specified
  if (!is.null(ncores) && ncores > 1) {
    cl <- makeCluster(ncores, type = "PSOCK")
    # Export necessary variables and functions to the cluster
    clusterExport(cl, varlist = c("TmW_Lap", "permZjade", "ICA", "eps", "maxiter", "iseed"), envir = environment())
    clusterSetRNGStream(cl, iseed)  # Set RNG stream for reproducibility
    
    # Use parSapply to perform the permutations in parallel
    Tperm <- parSapply(cl, seq_len(n.perm), function(i) {
      TmW_Lap(permZjade(ICA$S, eps = eps, maxiter = maxiter))
    })
    
    # Stop the cluster after use
    stopCluster(cl)
  } else {
    # Fallback to sequential processing if no cores are specified
    Tperm <- replicate(n.perm, TmW_Lap(permZjade(ICA$S, eps = eps, maxiter = maxiter)))
  }
  
  # Calculate the p-value
  PVAL <- (sum(T.W < Tperm) + 1) / (n.perm + 1)
  
  # Return the results
  RES <- list(T = T.W, Tperm = Tperm, pval = PVAL, ICA = ICA)
  return(RES)
}

ICAtestLap_fobi_perm_par <- function(X, n.perm = 200, ncores = NULL, iseed = NULL) {
  ICA <- FOBI(X)
  T.W <- TmW_Lap(ICA$S)
  
  # Set up parallel environment if more than one core is specified
  if (!is.null(ncores) && ncores > 1) {
    cl <- makeCluster(ncores, type = "PSOCK")
    # Export necessary variables and functions to the cluster
    clusterExport(cl, varlist = c("TmW_Lap", "permZfobi", "ICA", "iseed"), envir = environment())
    clusterSetRNGStream(cl, iseed)  # Set RNG stream for reproducibility
    
    # Use parSapply to perform the permutations in parallel
    Tperm <- parSapply(cl, seq_len(n.perm), function(i) {
      TmW_Lap(permZfobi(ICA$S))
    })
    
    # Stop the cluster after use
    stopCluster(cl)
  } else {
    # Fallback to sequential processing if no cores are specified
    Tperm <- replicate(n.perm, TmW_Lap(permZfobi(ICA$S)))
  }
  
  # Calculate the p-value
  PVAL <- (sum(T.W < Tperm) + 1) / (n.perm + 1)
  
  # Return the results
  RES <- list(T = T.W, Tperm = Tperm, pval = PVAL, ICA = ICA)
  return(RES)
}


ICAtestLap_fICA_perm_par <- function(X, n.perm = 200, g = "tanh", method = "sym", inR = FALSE, maxiter = 500, eps=1e-06, n.init=2, ncores = NULL, iseed = NULL) {
  ICA <- fICA(X, g = g, method = method, inR = inR, maxiter = maxiter, n.init = n.init, eps = eps)
  T.W <- TmW_Lap(ICA$S)
  
  # Set up parallel environment if more than one core is specified
  if (!is.null(ncores) && ncores > 1) {
    cl <- makeCluster(ncores, type = "PSOCK")
    # Export necessary variables and functions to the cluster
    clusterExport(cl, varlist = c("TmW_Lap", "permZfICA", "ICA", "g", "method", "inR", "maxiter", "n.init", "eps", "iseed"), envir = environment())
    clusterSetRNGStream(cl, iseed)  # Set RNG stream for reproducibility
    
    # Use parSapply to perform the permutations in parallel
    Tperm <- parSapply(cl, seq_len(n.perm), function(i) {
      TmW_Lap(permZfICA(ICA$S, g = g, method = method, inR = inR, maxiter = maxiter, n.init = n.init, eps = eps))
    })
    
    # Stop the cluster after use
    stopCluster(cl)
  } else {
    # Fallback to sequential processing if no cores are specified
    Tperm <- replicate(n.perm, TmW_Lap(permZfICA(ICA$S, g = g, method = method, inR = inR, maxiter = maxiter, n.init = n.init, eps = eps)))
  }
  
  # Calculate the p-value
  PVAL <- (sum(T.W < Tperm) + 1) / (n.perm + 1)
  
  # Return the results
  RES <- list(T = T.W, Tperm = Tperm, pval = PVAL, ICA = ICA)
  return(RES)
}



ICAtestLap_S_perm_par <- function(X, n.perm = 200, ncores = NULL, iseed = NULL) {
  S <- scale(X)
  T.W <- TmW_Lap(S)
  
  # Set up parallel environment if more than one core is specified
  if (!is.null(ncores) && ncores > 1) {
    cl <- makeCluster(ncores, type = "PSOCK")
    # Export necessary variables and functions to the cluster
    clusterExport(cl, varlist = c("TmW_Lap", "permS", "S", "iseed"), envir = environment())
    clusterSetRNGStream(cl, iseed)  # Set RNG stream for reproducibility
    
    # Use parSapply to perform the permutations in parallel
    Tperm <- parSapply(cl, seq_len(n.perm), function(i) {
      TmW_Lap(scale(permS(S)))
    })
    
    # Stop the cluster after use
    stopCluster(cl)
  } else {
    # Fallback to sequential processing if no cores are specified
    Tperm <- replicate(n.perm, TmW_Lap(scale(permS(S))))
  }
  
  # Calculate the p-value
  PVAL <- (sum(T.W < Tperm) + 1) / (n.perm + 1)
  
  # Return the results
  RES <- list(T = T.W, Tperm = Tperm, pval = PVAL)
  return(RES)
}


ICAtestRankGauss_jade_perm_par <- function(X, n.perm = 200, eps = 1e-06, maxiter = 100, ncores = NULL, iseed = NULL) {
  ICA <- JADE(X, eps = eps, maxiter = maxiter)
  R <- RANKS(ICA$S)
  T.W <- TmW_Gauss(R)
  
  # Set up parallel environment if more than one core is specified
  if (!is.null(ncores) && ncores > 1) {
    cl <- makeCluster(ncores, type = "PSOCK")
    # Export necessary variables and functions to the cluster
    clusterExport(cl, varlist = c("TmW_Gauss", "RANKS", "permZjade", "ICA", "eps", "maxiter", "iseed"), envir = environment())
    clusterSetRNGStream(cl, iseed)  # Set RNG stream for reproducibility
    
    # Use parSapply to perform the permutations in parallel
    Tperm <- parSapply(cl, seq_len(n.perm), function(i) {
      TmW_Gauss(RANKS(permZjade(ICA$S, eps = eps, maxiter = maxiter)))
    })
    
    # Stop the cluster after use
    stopCluster(cl)
  } else {
    # Fallback to sequential processing if no cores are specified
    Tperm <- replicate(n.perm, TmW_Gauss(RANKS(permZjade(ICA$S, eps = eps, maxiter = maxiter))))
  }
  
  # Calculate the p-value
  PVAL <- (sum(T.W < Tperm) + 1) / (n.perm + 1)
  
  # Return the results
  RES <- list(T = T.W, Tperm = Tperm, pval = PVAL, ICA = ICA)
  return(RES)
}


ICAtestRankGauss_fobi_perm_par <- function(X, n.perm = 200, ncores = NULL, iseed = NULL) {
  ICA <- FOBI(X)
  R <- RANKS(ICA$S)
  T.W <- TmW_Gauss(R)
  
  # Set up parallel environment if more than one core is specified
  if (!is.null(ncores) && ncores > 1) {
    cl <- makeCluster(ncores, type = "PSOCK")
    # Export necessary variables and functions to the cluster
    clusterExport(cl, varlist = c("TmW_Gauss", "RANKS", "permZfobi", "ICA", "iseed"), envir = environment())
    clusterSetRNGStream(cl, iseed)  # Set RNG stream for reproducibility
    
    # Use parSapply to perform the permutations in parallel
    Tperm <- parSapply(cl, seq_len(n.perm), function(i) {
      TmW_Gauss(RANKS(permZfobi(ICA$S)))
    })
    
    # Stop the cluster after use
    stopCluster(cl)
  } else {
    # Fallback to sequential processing if no cores are specified
    Tperm <- replicate(n.perm, TmW_Gauss(RANKS(permZfobi(ICA$S))))
  }
  
  # Calculate the p-value
  PVAL <- (sum(T.W < Tperm) + 1) / (n.perm + 1)
  
  # Return the results
  RES <- list(T = T.W, Tperm = Tperm, pval = PVAL, ICA = ICA)
  return(RES)
}


ICAtestRankGauss_fICA_perm_par <- function(X, n.perm = 200, g = "tanh", method = "sym", inR = FALSE, maxiter = 500, eps=1e-06, n.init=2, ncores = NULL, iseed = NULL) {
  ICA <- fICA(X, g = g, method = method, inR = inR, maxiter = maxiter, n.init = n.init, eps = eps)
  R <- RANKS(ICA$S)
  T.W <- TmW_Gauss(R)
  
  # Set up parallel environment if more than one core is specified
  if (!is.null(ncores) && ncores > 1) {
    cl <- makeCluster(ncores, type = "PSOCK")
    # Export necessary variables and functions to the cluster
    clusterExport(cl, varlist = c("TmW_Gauss", "RANKS", "permZfICA", "ICA", "g", "method", "inR", "maxiter", "n.init", "eps", "iseed"), envir = environment())
    clusterSetRNGStream(cl, iseed)  # Set RNG stream for reproducibility
    
    # Use parSapply to perform the permutations in parallel
    Tperm <- parSapply(cl, seq_len(n.perm), function(i) {
      TmW_Gauss(RANKS(permZfICA(ICA$S, g = g, method = method, inR = inR, maxiter = maxiter, n.init = n.init, eps = eps)))
    })
    
    # Stop the cluster after use
    stopCluster(cl)
  } else {
    # Fallback to sequential processing if no cores are specified
    Tperm <- replicate(n.perm, TmW_Gauss(RANKS(permZfICA(ICA$S, g = g, method = method, inR = inR, maxiter = maxiter, n.init = n.init, eps = eps))))
  }
  
  # Calculate the p-value
  PVAL <- (sum(T.W < Tperm) + 1) / (n.perm + 1)
  
  # Return the results
  RES <- list(T = T.W, Tperm = Tperm, pval = PVAL, ICA = ICA)
  return(RES)
}


ICAtestRankGauss_S_perm_par <- function(X, n.perm = 200, ncores = NULL, iseed = NULL) {
  S <- scale(X)
  R <- RANKS(S)
  T.W <- TmW_Gauss(R)
  
  # Set up parallel environment if more than one core is specified
  if (!is.null(ncores) && ncores > 1) {
    cl <- makeCluster(ncores, type = "PSOCK")
    # Export necessary variables and functions to the cluster
    clusterExport(cl, varlist = c("TmW_Gauss", "RANKS", "permS", "S", "iseed"), envir = environment())
    clusterSetRNGStream(cl, iseed)  # Set RNG stream for reproducibility
    
    # Use parSapply to perform the permutations in parallel
    Tperm <- parSapply(cl, seq_len(n.perm), function(i) {
      TmW_Gauss(RANKS(scale(permS(S))))
    })
    
    # Stop the cluster after use
    stopCluster(cl)
  } else {
    # Fallback to sequential processing if no cores are specified
    Tperm <- replicate(n.perm, TmW_Gauss(RANKS(scale(permS(S)))))
  }
  
  # Calculate the p-value
  PVAL <- (sum(T.W < Tperm) + 1) / (n.perm + 1)
  
  # Return the results
  RES <- list(T = T.W, Tperm = Tperm, pval = PVAL)
  return(RES)
}


ICAtestRankLap_jade_perm_par <- function(X, n.perm = 200, eps = 1e-06, maxiter = 100, ncores = NULL, iseed = NULL) {
  ICA <- JADE(X, eps = eps, maxiter = maxiter)
  R <- RANKS(ICA$S)
  T.W <- TmW_Lap(R)
  
  # Setup parallel
  if (!is.null(ncores) && ncores > 1) {
    cl <- makeCluster(ncores, type = "PSOCK")
    clusterExport(cl, varlist = c("TmW_Lap", "RANKS", "permZjade", "ICA", "eps", "maxiter", "iseed"), envir = environment())
    clusterSetRNGStream(cl, iseed)
    
    Tperm <- parSapply(cl, seq_len(n.perm), function(i) {
      TmW_Lap(RANKS(permZjade(ICA$S, eps = eps, maxiter = maxiter)))
    })
    stopCluster(cl)
  } else {
    Tperm <- replicate(n.perm, TmW_Lap(RANKS(permZjade(ICA$S, eps = eps, maxiter = maxiter))))
  }
  
  PVAL <- (sum(T.W < Tperm) + 1) / (n.perm + 1)
  RES <- list(T = T.W, Tperm = Tperm, pval = PVAL, ICA = ICA)
  return(RES)
}


ICAtestRankLap_fobi_perm_par <- function(X, n.perm = 200, ncores = NULL, iseed = NULL) {
  ICA <- FOBI(X)
  R <- RANKS(ICA$S)
  T.W <- TmW_Lap(R)
  
  # Setup parallel
  if (!is.null(ncores) && ncores > 1) {
    cl <- makeCluster(ncores, type = "PSOCK")
    clusterExport(cl, varlist = c("TmW_Lap", "RANKS", "permZfobi", "ICA", "iseed"), envir = environment())
    clusterSetRNGStream(cl, iseed)
    
    Tperm <- parSapply(cl, seq_len(n.perm), function(i) {
      TmW_Lap(RANKS(permZfobi(ICA$S)))
    })
    stopCluster(cl)
  } else {
    Tperm <- replicate(n.perm, TmW_Lap(RANKS(permZfobi(ICA$S))))
  }
  
  PVAL <- (sum(T.W < Tperm) + 1) / (n.perm + 1)
  RES <- list(T = T.W, Tperm = Tperm, pval = PVAL, ICA = ICA)
  return(RES)
}


ICAtestRankLap_fICA_perm_par <- function(X, n.perm = 200, g = "tanh", method = "sym", inR = FALSE, maxiter = 500, eps=1e-06, n.init=2, ncores = NULL, iseed = NULL) {
  ICA <- fICA(X, g = g, method = method, inR = inR, maxiter = maxiter, n.init = n.init, eps = eps)
  R <- RANKS(ICA$S)
  T.W <- TmW_Lap(R)
  
  # Setup parallel
  if (!is.null(ncores) && ncores > 1) {
    cl <- makeCluster(ncores, type = "PSOCK")
    clusterExport(cl, varlist = c("TmW_Lap", "RANKS", "permZfICA", "ICA", "g", "method", "inR", "maxiter", "n.init", "eps", "iseed"), envir = environment())
    clusterSetRNGStream(cl, iseed)
    
    Tperm <- parSapply(cl, seq_len(n.perm), function(i) {
      TmW_Lap(RANKS(permZfICA(ICA$S, g, method, inR, maxiter, n.init, eps)))
    })
    stopCluster(cl)
  } else {
    Tperm <- replicate(n.perm, TmW_Lap(RANKS(permZfICA(ICA$S, g, method, inR, maxiter, n.init, eps))))
  }
  
  PVAL <- (sum(T.W < Tperm) + 1) / (n.perm + 1)
  RES <- list(T = T.W, Tperm = Tperm, pval = PVAL, ICA = ICA)
  return(RES)
}

ICAtestRankLap_S_perm_par <- function(X, n.perm = 200, ncores = NULL, iseed = NULL) {
  S <- scale(X)
  R <- RANKS(S)
  T.W <- TmW_Lap(R)
  
  # Setup parallel
  if (!is.null(ncores) && ncores > 1) {
    cl <- makeCluster(ncores, type = "PSOCK")
    clusterExport(cl, varlist = c("TmW_Lap", "RANKS", "permS", "S", "iseed"), envir = environment())
    clusterSetRNGStream(cl, iseed)
    
    Tperm <- parSapply(cl, seq_len(n.perm), function(i) {
      TmW_Lap(RANKS(scale(permS(S))))
    })
    stopCluster(cl)
  } else {
    Tperm <- replicate(n.perm, TmW_Lap(RANKS(scale(permS(S)))))
  }
  
  PVAL <- (sum(T.W < Tperm) + 1) / (n.perm + 1)
  RES <- list(T = T.W, Tperm = Tperm, pval = PVAL)
  return(RES)
}




ICAtestRankvdW_fobi_perm_par <- function(X, n.perm = 200, ncores = NULL, iseed = NULL) {
  ICA <- FOBI(X)
  R <- VdW(ICA$S)
  T.W <- TmW_Gauss(R)
  
  if (!is.null(ncores) && ncores > 1) {
    cl <- makeCluster(ncores, type = "PSOCK")
    clusterExport(cl, varlist = c("TmW_Gauss", "VdW", "permZfobi", "ICA", "iseed"), envir = environment())
    clusterSetRNGStream(cl, iseed)
    
    Tperm <- parSapply(cl, seq_len(n.perm), function(i) {
      TmW_Gauss(VdW(permZfobi(ICA$S)))
    })
    stopCluster(cl)
  } else {
    Tperm <- replicate(n.perm, TmW_Gauss(VdW(permZfobi(ICA$S))))
  }
  
  PVAL <- (sum(T.W < Tperm) + 1) / (n.perm + 1)
  RES <- list(T = T.W, Tperm = Tperm, pval = PVAL, ICA = ICA)
  return(RES)
}


ICAtestRankvdW_fICA_perm_par <- function(X, n.perm = 200, g = "tanh", method = "sym", inR = FALSE, maxiter = 500, eps=1e-06, n.init=2, ncores = NULL, iseed = NULL) {
  ICA <- fICA(X, g = g, method = method, inR = inR, maxiter = maxiter, n.init = n.init, eps = eps)
  R <- VdW(ICA$S)
  T.W <- TmW_Gauss(R)
  
  if (!is.null(ncores) && ncores > 1) {
    cl <- makeCluster(ncores, type = "PSOCK")
    clusterExport(cl, varlist = c("TmW_Gauss", "VdW", "permZfICA", "ICA", "g", "method", "inR", "maxiter", "n.init", "eps", "iseed"), envir = environment())
    clusterSetRNGStream(cl, iseed)
    
    Tperm <- parSapply(cl, seq_len(n.perm), function(i) {
      TmW_Gauss(VdW(permZfICA(ICA$S, g, method, inR, maxiter, n.init, eps)))
    })
    stopCluster(cl)
  } else {
    Tperm <- replicate(n.perm, TmW_Gauss(VdW(permZfICA(ICA$S, g, method, inR, maxiter, n.init, eps))))
  }
  
  PVAL <- (sum(T.W < Tperm) + 1) / (n.perm + 1)
  RES <- list(T = T.W, Tperm = Tperm, pval = PVAL, ICA = ICA)
  return(RES)
}

ICAtestRankvdW_S_perm_par <- function(X, n.perm = 200, ncores = NULL, iseed = NULL) {
  S <- scale(X)
  R <- VdW(S)
  T.W <- TmW_Gauss(R)
  
  if (!is.null(ncores) && ncores > 1) {
    cl <- makeCluster(ncores, type = "PSOCK")
    clusterExport(cl, varlist = c("TmW_Gauss", "VdW", "permS", "S", "iseed"), envir = environment())
    clusterSetRNGStream(cl, iseed)
    
    Tperm <- parSapply(cl, seq_len(n.perm), function(i) {
      TmW_Gauss(VdW(scale(permS(S))))
    })
    stopCluster(cl)
  } else {
    Tperm <- replicate(n.perm, TmW_Gauss(VdW(scale(permS(S)))))
  }
  
  PVAL <- (sum(T.W < Tperm) + 1) / (n.perm + 1)
  RES <- list(T = T.W, Tperm = Tperm, pval = PVAL)
  return(RES)
}
