% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_t_test.R
\name{boot_t_test}
\alias{boot_t_test}
\alias{boot_t_test.default}
\alias{boot_t_test.formula}
\title{Bootstrapped t-test}
\usage{
boot_t_test(x, ...)

\method{boot_t_test}{default}(
  x,
  y = NULL,
  var.equal = FALSE,
  paired = FALSE,
  alternative = c("two.sided", "less", "greater", "equivalence", "minimal.effect"),
  mu = 0,
  alpha = 0.05,
  boot_ci = c("stud", "basic", "perc"),
  R = 1999,
  ...
)

\method{boot_t_test}{formula}(formula, data, subset, na.action, ...)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{...}{further arguments to be passed to or from the underlying test functions.}

\item{y}{an optional (non-empty) numeric vector of data values.}

\item{var.equal}{a logical variable indicating whether to treat the two variances as being equal. If TRUE then the pooled variance is used to estimate the variance otherwise the Welch (or Satterthwaite) approximation to the degrees of freedom is used.}

\item{paired}{a logical indicating whether you want a paired t-test.}

\item{alternative}{the alternative hypothesis:
* "two.sided": different from mu (default)
* "less": less than mu
* "greater": greater than mu
* "equivalence": between specified bounds
* "minimal.effect": outside specified bounds}

\item{mu}{a number or vector specifying the null hypothesis value(s):
* For standard alternatives: a single value (default = 0)
* For equivalence/minimal.effect: two values representing the lower and upper bounds}

\item{alpha}{alpha level (default = 0.05)}

\item{boot_ci}{method for bootstrap confidence interval calculation: "stud" (studentized, default), "basic" (basic bootstrap), or "perc" (percentile bootstrap).}

\item{R}{number of bootstrap replications (default = 1999).}

\item{formula}{a formula of the form lhs ~ rhs where lhs is a numeric variable giving the data values and rhs either 1 for a one-sample or paired test or a factor with two levels giving the corresponding groups. If lhs is of class "Pair" and rhs is 1, a paired test is done.}

\item{data}{an optional matrix or data frame (or similar: see model.frame) containing the variables in the formula formula. By default the variables are taken from environment(formula).}

\item{subset}{an optional vector specifying a subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when the data contain NAs. Defaults to getOption("na.action").}
}
\value{
A list with class \code{"htest"} containing the following components:
\itemize{
\item "p.value": the bootstrapped p-value for the test.
\item "stderr": the bootstrapped standard error.
\item "conf.int": a bootstrapped confidence interval for the mean appropriate to the specified alternative hypothesis.
\item "estimate": the estimated mean or difference in means.
\item "null.value": the specified hypothesized value(s) of the mean or mean difference.
\item "alternative": a character string describing the alternative hypothesis.
\item "method": a character string indicating what type of bootstrapped t-test was performed.
\item "boot": the bootstrap samples of the mean or mean difference.
\item "data.name": a character string giving the name(s) of the data.
\item "call": the matched call.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Performs t-tests with bootstrapped p-values and confidence intervals. This function supports
standard hypothesis testing alternatives as well as equivalence and minimal effect testing,
all with the familiar \code{htest} output structure.
}
\details{
This function performs bootstrapped t-tests, providing more robust inference than standard
parametric t-tests. It supports one-sample, two-sample (independent), and paired designs,
as well as five different alternative hypotheses.

The bootstrap procedure follows these steps:
\itemize{
\item Calculate the test statistic from the original data
\item Generate R bootstrap samples by resampling with replacement
\item Calculate the test statistic for each bootstrap sample
\item Compute the p-value by comparing the original test statistic to the bootstrap distribution
\item Calculate confidence intervals using the specified bootstrap method
}

Three bootstrap confidence interval methods are available:
\itemize{
\item \emph{Studentized bootstrap ("stud")}: Accounts for the variability in standard error estimates
\item \emph{Basic bootstrap ("basic")}: Uses the empirical distribution of bootstrap estimates
\item \emph{Percentile bootstrap ("perc")}: Uses percentiles of the bootstrap distribution directly
}

For different alternatives, the p-values are calculated as follows:
\itemize{
\item "two.sided": Proportion of bootstrap statistics at least as extreme as the observed statistic (in either direction), multiplied by 2
\item "less": Proportion of bootstrap statistics less than or equal to the observed statistic
\item "greater": Proportion of bootstrap statistics greater than or equal to the observed statistic
\item "equivalence": Maximum of two one-sided p-values (for lower and upper bounds)
\item "minimal.effect": Minimum of two one-sided p-values (for lower and upper bounds)
}

For two-sample tests, the test is of \eqn{\bar x - \bar y} (mean of x minus mean of y).
For paired samples, the test is of the difference scores (z),
wherein \eqn{z = x - y}, and the test is of \eqn{\bar z} (mean of the difference scores).
For one-sample tests, the test is of \eqn{\bar x} (mean of x).

Unlike the \code{t_TOST} function, this function returns a standard \code{htest} object for
compatibility with other R functions, while still providing the benefits of bootstrapping.

For detailed information on calculation methods, see \code{vignette("robustTOST")}.
}
\section{Purpose}{

Use this function when:
\itemize{
\item You need more robust inference than provided by standard t-tests
\item Your data don't meet the assumptions of normality or homogeneity
\item You want to perform equivalence or minimal effect testing with bootstrap methods
\item Sample sizes are small or standard parametric approaches may be unreliable
\item You prefer the standard \code{htest} output format for compatibility with other R functions
}
}

\examples{

# Example 1: Basic two-sample test with formula notation
data(sleep)
result <- boot_t_test(extra ~ group, data = sleep)
result  # Standard htest output format

# Example 2: One-sample bootstrapped t-test
set.seed(123)
x <- rnorm(20, mean = 0.5, sd = 1)
boot_t_test(x, mu = 0, R = 999) # Using fewer replicates for demonstration

# Example 3: Paired samples test with percentile bootstrap CI
before <- c(5.1, 4.8, 6.2, 5.7, 6.0, 5.5, 4.9, 5.8)
after <- c(5.6, 5.2, 6.7, 6.1, 6.5, 5.8, 5.3, 6.2)
boot_t_test(x = before, y = after,
            paired = TRUE,
            alternative = "less",  # Testing if before < after
            boot_ci = "perc",
            R = 999)

# Example 4: Equivalence testing with bootstrapped t-test
# Testing if the effect is within ±0.5 units
data(mtcars)
boot_t_test(mpg ~ am, data = mtcars,
            alternative = "equivalence",
            mu = c(-0.5, 0.5),
            boot_ci = "stud",
            R = 999)

# Example 5: Minimal effect testing with bootstrapped t-test
# Testing if the effect is outside ±3 units
boot_t_test(mpg ~ am, data = mtcars,
            alternative = "minimal.effect",
            mu = c(-3, 3),
            R = 999)

}
\references{
Efron, B., & Tibshirani, R. J. (1994). An introduction to the bootstrap. CRC press.
}
\seealso{
Other Robust tests: 
\code{\link{boot_log_TOST}()},
\code{\link{boot_t_TOST}()},
\code{\link{brunner_munzel}()},
\code{\link{log_TOST}()},
\code{\link{wilcox_TOST}()}
}
\concept{Robust tests}
