% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_calc.R
\name{ses_calc}
\alias{ses_calc}
\alias{ses_calc.default}
\alias{ses_calc.formula}
\title{Standardized Effect Size (SES) Calculation}
\usage{
ses_calc(x, ..., paired = FALSE, ses = "rb", alpha = 0.05)

\method{ses_calc}{default}(
  x,
  y = NULL,
  paired = FALSE,
  ses = c("rb", "odds", "logodds", "cstat"),
  alpha = 0.05,
  mu = 0,
  ...
)

\method{ses_calc}{formula}(formula, data, subset, na.action, ...)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{...}{further arguments to be passed to or from methods.}

\item{paired}{a logical indicating whether you want a paired t-test.}

\item{ses}{a character string specifying the effect size measure to calculate:
- "rb": rank-biserial correlation (default)
- "odds": Wilcoxon-Mann-Whitney odds
- "logodds": Wilcoxon-Mann-Whitney log-odds
- "cstat": concordance statistic (C-statistic, equivalent to the area under the ROC curve)}

\item{alpha}{alpha level for confidence interval calculation (default = 0.05).}

\item{y}{an optional (non-empty) numeric vector of data values.}

\item{mu}{number indicating the value around which asymmetry (for one-sample or paired samples)
or shift (for independent samples) is to be estimated (default = 0).}

\item{formula}{a formula of the form lhs ~ rhs where lhs is a numeric variable giving the data values and rhs either 1 for a one-sample or paired test or a factor with two levels giving the corresponding groups. If lhs is of class "Pair" and rhs is 1, a paired test is done.}

\item{data}{an optional matrix or data frame (or similar: see model.frame) containing the variables in the formula formula. By default the variables are taken from environment(formula).}

\item{subset}{an optional vector specifying a subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when the data contain NAs. Defaults to getOption("na.action").}
}
\value{
A data frame containing the following information:
\itemize{
\item estimate: The effect size estimate
\item lower.ci: Lower bound of the confidence interval
\item upper.ci: Upper bound of the confidence interval
\item conf.level: Confidence level (1-alpha)
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Calculates non-SMD standardized effect sizes for group comparisons. This function focuses on
rank-based and probability-based effect size measures, which are especially useful for
non-parametric analyses and when data do not meet normality assumptions.
}
\details{
This function calculates standardized effect sizes that are not standardized mean differences (SMDs).
These effect sizes are particularly useful for non-parametric analyses or when data violate
assumptions of normality.

The available effect size measures are:
\itemize{
\item \strong{Rank-biserial correlation ("rb")}: A correlation coefficient based on ranks,
ranging from -1 to 1. It can be interpreted as the difference between the proportion of
favorable pairs and the proportion of unfavorable pairs. For independent samples, this is
equivalent to Cliff's delta.
\item \strong{Wilcoxon-Mann-Whitney odds ("odds")}: The ratio of the probability that a
randomly selected observation from group 1 exceeds a randomly selected observation from
group 2, to the probability of the reverse. Values range from 0 to infinity, with 1
indicating no effect.
\item \strong{Wilcoxon-Mann-Whitney log-odds ("logodds")}: The natural logarithm of the
WMW odds. This transforms the odds scale to range from negative infinity to positive
infinity, with 0 indicating no effect.
\item \strong{Concordance statistic ("cstat")}: The probability that a randomly selected
observation from group 1 exceeds a randomly selected observation from group 2. Also known
as the common language effect size or the area under the ROC curve. Values range from 0 to
1, with 0.5 indicating no effect.
}

The function supports three study designs:
\itemize{
\item One-sample design: Compares a single sample to a specified value
\item Two-sample independent design: Compares two independent groups
\item Paired samples design: Compares paired observations
}

For detailed information on calculation methods, see \code{vignette("robustTOST")}.
}
\section{Purpose}{

Use this function when:
\itemize{
\item You want to report non-parametric effect size measures
\item You need to quantify the magnitude of differences using ranks or probabilities
\item Your outcome variable is ordinal
\item You want to complement results from Wilcoxon-Mann-Whitney type test
}
}

\examples{
# Example 1: Independent groups comparison (rank-biserial correlation)
set.seed(123)
group1 <- c(1.2, 2.3, 3.1, 4.6, 5.2, 6.7)
group2 <- c(3.5, 4.8, 5.6, 6.9, 7.2, 8.5)
ses_calc(x = group1, y = group2, ses = "rb")

# Example 2: Using formula notation to calculate WMW odds
data(mtcars)
ses_calc(formula = mpg ~ am, data = mtcars, ses = "odds")

# Example 3: Paired samples with concordance statistic
data(sleep)
with(sleep, ses_calc(x = extra[group == 1],
                     y = extra[group == 2],
                     paired = TRUE,
                     ses = "cstat"))

}
\seealso{
Other effect sizes: 
\code{\link{boot_ses_calc}()},
\code{\link{boot_smd_calc}()},
\code{\link{smd_calc}()}
}
\concept{effect sizes}
