#' Continuation dataset of the Dataset A of the NN5 Competition 
#' 
#' A dataset of univariate time series providing 56 points beyond the end of
#' the time series in \code{\link{NN5.A}}. 
#' 
#' Contains the 56 observations which were to be predicted of each time series
#' in Dataset A (\code{\link{NN5.A}}) as demanded by the NN5 Competition. 
#' 
#' @name NN5.A.cont
#' @docType data
#' @format A data frame with 56 observations on the following 111 variables.
#' \describe{ \item{NN5.001}{a numeric vector containing further
#' observations of \code{NN5.001} in \code{\link{NN5.A}}.}
#' \item{NN5.002}{a numeric vector containing further observations of
#' \code{NN5.002} in \code{\link{NN5.A}}.} \item{NN5.003}{a numeric
#' vector containing further observations of \code{NN5.003} in
#' \code{\link{NN5.A}}.} \item{NN5.004}{a numeric vector containing
#' further observations of \code{NN5.004} in \code{\link{NN5.A}}.}
#' \item{NN5.005}{a numeric vector containing further observations of
#' \code{NN5.005} in \code{\link{NN5.A}}.} \item{NN5.006}{a numeric
#' vector containing further observations of \code{NN5.006} in
#' \code{\link{NN5.A}}.} \item{NN5.007}{a numeric vector containing
#' further observations of \code{NN5.007} in \code{\link{NN5.A}}.}
#' \item{NN5.008}{a numeric vector containing further observations of
#' \code{NN5.008} in \code{\link{NN5.A}}.} \item{NN5.009}{a numeric
#' vector containing further observations of \code{NN5.009} in
#' \code{\link{NN5.A}}.} \item{NN5.010}{a numeric vector containing
#' further observations of \code{NN5.010} in \code{\link{NN5.A}}.}
#' \item{NN5.011}{a numeric vector containing further observations of
#' \code{NN5.011} in \code{\link{NN5.A}}.} \item{NN5.012}{a numeric
#' vector containing further observations of \code{NN5.012} in
#' \code{\link{NN5.A}}.} \item{NN5.013}{a numeric vector containing
#' further observations of \code{NN5.013} in \code{\link{NN5.A}}.}
#' \item{NN5.014}{a numeric vector containing further observations of
#' \code{NN5.014} in \code{\link{NN5.A}}.} \item{NN5.015}{a numeric
#' vector containing further observations of \code{NN5.015} in
#' \code{\link{NN5.A}}.} \item{NN5.016}{a numeric vector containing
#' further observations of \code{NN5.016} in \code{\link{NN5.A}}.}
#' \item{NN5.017}{a numeric vector containing further observations of
#' \code{NN5.017} in \code{\link{NN5.A}}.} \item{NN5.018}{a numeric
#' vector containing further observations of \code{NN5.018} in
#' \code{\link{NN5.A}}.} \item{NN5.019}{a numeric vector containing
#' further observations of \code{NN5.019} in \code{\link{NN5.A}}.}
#' \item{NN5.020}{a numeric vector containing further observations of
#' \code{NN5.020} in \code{\link{NN5.A}}.} \item{NN5.021}{a numeric
#' vector containing further observations of \code{NN5.021} in
#' \code{\link{NN5.A}}.} \item{NN5.022}{a numeric vector containing
#' further observations of \code{NN5.022} in \code{\link{NN5.A}}.}
#' \item{NN5.023}{a numeric vector containing further observations of
#' \code{NN5.023} in \code{\link{NN5.A}}.} \item{NN5.024}{a numeric
#' vector containing further observations of \code{NN5.024} in
#' \code{\link{NN5.A}}.} \item{NN5.025}{a numeric vector containing
#' further observations of \code{NN5.025} in \code{\link{NN5.A}}.}
#' \item{NN5.026}{a numeric vector containing further observations of
#' \code{NN5.026} in \code{\link{NN5.A}}.} \item{NN5.027}{a numeric
#' vector containing further observations of \code{NN5.027} in
#' \code{\link{NN5.A}}.} \item{NN5.028}{a numeric vector containing
#' further observations of \code{NN5.028} in \code{\link{NN5.A}}.}
#' \item{NN5.029}{a numeric vector containing further observations of
#' \code{NN5.029} in \code{\link{NN5.A}}.} \item{NN5.030}{a numeric
#' vector containing further observations of \code{NN5.030} in
#' \code{\link{NN5.A}}.} \item{NN5.031}{a numeric vector containing
#' further observations of \code{NN5.031} in \code{\link{NN5.A}}.}
#' \item{NN5.032}{a numeric vector containing further observations of
#' \code{NN5.032} in \code{\link{NN5.A}}.} \item{NN5.033}{a numeric
#' vector containing further observations of \code{NN5.033} in
#' \code{\link{NN5.A}}.} \item{NN5.034}{a numeric vector containing
#' further observations of \code{NN5.034} in \code{\link{NN5.A}}.}
#' \item{NN5.035}{a numeric vector containing further observations of
#' \code{NN5.035} in \code{\link{NN5.A}}.} \item{NN5.036}{a numeric
#' vector containing further observations of \code{NN5.036} in
#' \code{\link{NN5.A}}.} \item{NN5.037}{a numeric vector containing
#' further observations of \code{NN5.037} in \code{\link{NN5.A}}.}
#' \item{NN5.038}{a numeric vector containing further observations of
#' \code{NN5.038} in \code{\link{NN5.A}}.} \item{NN5.039}{a numeric
#' vector containing further observations of \code{NN5.039} in
#' \code{\link{NN5.A}}.} \item{NN5.040}{a numeric vector containing
#' further observations of \code{NN5.040} in \code{\link{NN5.A}}.}
#' \item{NN5.041}{a numeric vector containing further observations of
#' \code{NN5.041} in \code{\link{NN5.A}}.} \item{NN5.042}{a numeric
#' vector containing further observations of \code{NN5.042} in
#' \code{\link{NN5.A}}.} \item{NN5.043}{a numeric vector containing
#' further observations of \code{NN5.043} in \code{\link{NN5.A}}.}
#' \item{NN5.044}{a numeric vector containing further observations of
#' \code{NN5.044} in \code{\link{NN5.A}}.} \item{NN5.045}{a numeric
#' vector containing further observations of \code{NN5.045} in
#' \code{\link{NN5.A}}.} \item{NN5.046}{a numeric vector containing
#' further observations of \code{NN5.046} in \code{\link{NN5.A}}.}
#' \item{NN5.047}{a numeric vector containing further observations of
#' \code{NN5.047} in \code{\link{NN5.A}}.} \item{NN5.048}{a numeric
#' vector containing further observations of \code{NN5.048} in
#' \code{\link{NN5.A}}.} \item{NN5.049}{a numeric vector containing
#' further observations of \code{NN5.049} in \code{\link{NN5.A}}.}
#' \item{NN5.050}{a numeric vector containing further observations of
#' \code{NN5.050} in \code{\link{NN5.A}}.} \item{NN5.051}{a numeric
#' vector containing further observations of \code{NN5.051} in
#' \code{\link{NN5.A}}.} \item{NN5.052}{a numeric vector containing
#' further observations of \code{NN5.052} in \code{\link{NN5.A}}.}
#' \item{NN5.053}{a numeric vector containing further observations of
#' \code{NN5.053} in \code{\link{NN5.A}}.} \item{NN5.054}{a numeric
#' vector containing further observations of \code{NN5.054} in
#' \code{\link{NN5.A}}.} \item{NN5.055}{a numeric vector containing
#' further observations of \code{NN5.055} in \code{\link{NN5.A}}.}
#' \item{NN5.056}{a numeric vector containing further observations of
#' \code{NN5.056} in \code{\link{NN5.A}}.} \item{NN5.057}{a numeric
#' vector containing further observations of \code{NN5.057} in
#' \code{\link{NN5.A}}.} \item{NN5.058}{a numeric vector containing
#' further observations of \code{NN5.058} in \code{\link{NN5.A}}.}
#' \item{NN5.059}{a numeric vector containing further observations of
#' \code{NN5.059} in \code{\link{NN5.A}}.} \item{NN5.060}{a numeric
#' vector containing further observations of \code{NN5.060} in
#' \code{\link{NN5.A}}.} \item{NN5.061}{a numeric vector containing
#' further observations of \code{NN5.061} in \code{\link{NN5.A}}.}
#' \item{NN5.062}{a numeric vector containing further observations of
#' \code{NN5.062} in \code{\link{NN5.A}}.} \item{NN5.063}{a numeric
#' vector containing further observations of \code{NN5.063} in
#' \code{\link{NN5.A}}.} \item{NN5.064}{a numeric vector containing
#' further observations of \code{NN5.064} in \code{\link{NN5.A}}.}
#' \item{NN5.065}{a numeric vector containing further observations of
#' \code{NN5.065} in \code{\link{NN5.A}}.} \item{NN5.066}{a numeric
#' vector containing further observations of \code{NN5.066} in
#' \code{\link{NN5.A}}.} \item{NN5.067}{a numeric vector containing
#' further observations of \code{NN5.067} in \code{\link{NN5.A}}.}
#' \item{NN5.068}{a numeric vector containing further observations of
#' \code{NN5.068} in \code{\link{NN5.A}}.} \item{NN5.069}{a numeric
#' vector containing further observations of \code{NN5.069} in
#' \code{\link{NN5.A}}.} \item{NN5.070}{a numeric vector containing
#' further observations of \code{NN5.070} in \code{\link{NN5.A}}.}
#' \item{NN5.071}{a numeric vector containing further observations of
#' \code{NN5.071} in \code{\link{NN5.A}}.} \item{NN5.072}{a numeric
#' vector containing further observations of \code{NN5.072} in
#' \code{\link{NN5.A}}.} \item{NN5.073}{a numeric vector containing
#' further observations of \code{NN5.073} in \code{\link{NN5.A}}.}
#' \item{NN5.074}{a numeric vector containing further observations of
#' \code{NN5.074} in \code{\link{NN5.A}}.} \item{NN5.075}{a numeric
#' vector containing further observations of \code{NN5.075} in
#' \code{\link{NN5.A}}.} \item{NN5.076}{a numeric vector containing
#' further observations of \code{NN5.076} in \code{\link{NN5.A}}.}
#' \item{NN5.077}{a numeric vector containing further observations of
#' \code{NN5.077} in \code{\link{NN5.A}}.} \item{NN5.078}{a numeric
#' vector containing further observations of \code{NN5.078} in
#' \code{\link{NN5.A}}.} \item{NN5.079}{a numeric vector containing
#' further observations of \code{NN5.079} in \code{\link{NN5.A}}.}
#' \item{NN5.080}{a numeric vector containing further observations of
#' \code{NN5.080} in \code{\link{NN5.A}}.} \item{NN5.081}{a numeric
#' vector containing further observations of \code{NN5.081} in
#' \code{\link{NN5.A}}.} \item{NN5.082}{a numeric vector containing
#' further observations of \code{NN5.082} in \code{\link{NN5.A}}.}
#' \item{NN5.083}{a numeric vector containing further observations of
#' \code{NN5.083} in \code{\link{NN5.A}}.} \item{NN5.084}{a numeric
#' vector containing further observations of \code{NN5.084} in
#' \code{\link{NN5.A}}.} \item{NN5.085}{a numeric vector containing
#' further observations of \code{NN5.085} in \code{\link{NN5.A}}.}
#' \item{NN5.086}{a numeric vector containing further observations of
#' \code{NN5.086} in \code{\link{NN5.A}}.} \item{NN5.087}{a numeric
#' vector containing further observations of \code{NN5.087} in
#' \code{\link{NN5.A}}.} \item{NN5.088}{a numeric vector containing
#' further observations of \code{NN5.088} in \code{\link{NN5.A}}.}
#' \item{NN5.089}{a numeric vector containing further observations of
#' \code{NN5.089} in \code{\link{NN5.A}}.} \item{NN5.090}{a numeric
#' vector containing further observations of \code{NN5.090} in
#' \code{\link{NN5.A}}.} \item{NN5.091}{a numeric vector containing
#' further observations of \code{NN5.091} in \code{\link{NN5.A}}.}
#' \item{NN5.092}{a numeric vector containing further observations of
#' \code{NN5.092} in \code{\link{NN5.A}}.} \item{NN5.093}{a numeric
#' vector containing further observations of \code{NN5.093} in
#' \code{\link{NN5.A}}.} \item{NN5.094}{a numeric vector containing
#' further observations of \code{NN5.094} in \code{\link{NN5.A}}.}
#' \item{NN5.095}{a numeric vector containing further observations of
#' \code{NN5.095} in \code{\link{NN5.A}}.} \item{NN5.096}{a numeric
#' vector containing further observations of \code{NN5.096} in
#' \code{\link{NN5.A}}.} \item{NN5.097}{a numeric vector containing
#' further observations of \code{NN5.097} in \code{\link{NN5.A}}.}
#' \item{NN5.098}{a numeric vector containing further observations of
#' \code{NN5.098} in \code{\link{NN5.A}}.} \item{NN5.099}{a numeric
#' vector containing further observations of \code{NN5.099} in
#' \code{\link{NN5.A}}.} \item{NN5.100}{a numeric vector containing
#' further observations of \code{NN5.100} in \code{\link{NN5.A}}.}
#' \item{NN5.101}{a numeric vector containing further observations of
#' \code{NN5.101} in \code{\link{NN5.A}}.} \item{NN5.102}{a numeric
#' vector containing further observations of \code{NN5.102} in
#' \code{\link{NN5.A}}.} \item{NN5.103}{a numeric vector containing
#' further observations of \code{NN5.103} in \code{\link{NN5.A}}.}
#' \item{NN5.104}{a numeric vector containing further observations of
#' \code{NN5.104} in \code{\link{NN5.A}}.} \item{NN5.105}{a numeric
#' vector containing further observations of \code{NN5.105} in
#' \code{\link{NN5.A}}.} \item{NN5.106}{a numeric vector containing
#' further observations of \code{NN5.106} in \code{\link{NN5.A}}.}
#' \item{NN5.107}{a numeric vector containing further observations of
#' \code{NN5.107} in \code{\link{NN5.A}}.} \item{NN5.108}{a numeric
#' vector containing further observations of \code{NN5.108} in
#' \code{\link{NN5.A}}.} \item{NN5.109}{a numeric vector containing
#' further observations of \code{NN5.109} in \code{\link{NN5.A}}.}
#' \item{NN5.110}{a numeric vector containing further observations of
#' \code{NN5.110} in \code{\link{NN5.A}}.} \item{NN5.111}{a numeric
#' vector containing further observations of \code{NN5.111} in
#' \code{\link{NN5.A}}.} }
#' @seealso \code{\link{NN5.A}} ~
#' @references S.F. Crone, 2008, Results of the NN5 time series forecasting
#' competition. Hong Kong, Presentation at the IEEE world congress on
#' computational intelligence. WCCI'2008. 
#' @source NN5 2008, The NN5 Competition: Forecasting competition for
#' artificial neural networks and computational intelligence. URL:
#' \url{http://www.neural-forecasting-competition.com/NN5/index.htm}. 
#' @keywords datasets NN5 Time Series Competition
#' @examples
#' 
#' data(NN5.A.cont)
#' str(NN5.A.cont)
#' plot(ts(NN5.A.cont["NN5.111"]))
#' 
"NN5.A.cont"
#> [1] "NN5.A.cont"