% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WT.r
\name{WaveletT}
\alias{WaveletT}
\alias{WaveletT.rev}
\title{Automatic wavelet transform}
\usage{
WaveletT(
  x,
  level = NULL,
  filter = c("haar", "d4", "la8", "bl14", "c6"),
  boundary = "periodic",
  ...
)

WaveletT.rev(pred = NULL, wt_obj)
}
\arguments{
\item{x}{A numeric vector or univariate time series to be decomposed.}

\item{level}{An integer specifying the level of the decomposition. If
\code{NULL}, it is automatically selected using \code{\link{fittestWavelet}}.}

\item{filter}{A character string indicating which
wavelet filter to use in the decomposition. If \code{NULL}, or a vector and \code{length(filters)>1}, the
wavelet transform filter is automatically selected using \code{\link{fittestWavelet}}.}

\item{boundary}{See \code{\link[wavelets]{modwt}}.}

\item{...}{Additional arguments passed to \code{\link{fittestWavelet}}.}

\item{pred}{A list containing component series (such as) resulting from wavelet transform (\code{WaveletT()}).}

\item{wt_obj}{Object of class \code{\link[wavelets]{modwt}} containing the wavelet transformed series.}
}
\value{
A list containing each component series resulting from
the decomposition of \code{x} (\code{level} wavelet coefficients series and 
\code{level} scaling coefficients series).
An object of class \code{\link[wavelets]{modwt}} containing the wavelet transformed/decomposed
time series is passed as an attribute named "wt_obj".
This attribute is passed to \code{wt_obj} in \code{WaveletT.rev()}.
}
\description{
The function automatically applies a maximal overlap discrete wavelet
transform to a provided univariate time series. Wrapper function for \code{\link[wavelets]{modwt}}
of the \code{wavelets} package. It also allows the automatic selection
of the level and filter of the transform using \code{\link{fittestWavelet}}.
\code{WaveletT.rev()} reverses the transformation based on the \code{\link[wavelets]{imodwt}} function.
}
\examples{

data(CATS)
\donttest{
w <- WaveletT(CATS[,1])

#plot wavelet transform/decomposition
plot(attr(w,"wt_obj"))

x <- WaveletT.rev(pred=NULL, attr(w,"wt_obj"))

all(round(x,4)==round(CATS[,1],4))
}

}
\references{
A. J. Conejo, M. A. Plazas, R. Espinola, A. B. Molina, Day-ahead
electricity price forecasting using the wavelet transform and ARIMA models,
IEEE Transactions on Power Systems 20 (2005) 1035-1042.

T. Joo, S. Kim, Time series forecasting based on wavelet filtering, Expert
Systems with Applications 42 (2015) 3868-3874.

C. Stolojescu, I. Railean, S. M. P. Lenca, A. Isar, A wavelet based
prediction method for time series. In Proceedings of the 2010 International
Conference Stochastic Modeling Techniques and Data Analysis, Chania, Greece
(pp. 8-11) (2010). %% ~put references to the literature/web site here ~
}
\seealso{
\code{\link{fittestWavelet}}, \code{\link{fittestEMD}}

Other transformation methods: 
\code{\link{Diff}()},
\code{\link{LogT}()},
\code{\link{emd}()},
\code{\link{mas}()},
\code{\link{mlm_io}()},
\code{\link{outliers_bp}()},
\code{\link{pct}()},
\code{\link{train_test_subset}()}
}
\author{
Rebecca Pontes Salles
}
\concept{transformation methods}
\keyword{decomposition}
\keyword{transform}
\keyword{wavelet}
