% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_data.R
\docType{data}
\name{standard_globals}
\alias{standard_globals}
\title{Standard values for global parameters}
\format{
An object of class \code{numeric} of length 13.
}
\usage{
standard_globals
}
\description{
This vector contains the global parameter values for the process model, 
which must be supplied to the \code{make_data()} function. 
The time components are the units are per modelled time step and the length of these time 
steps are defined by the parameter seconds in \code{make_data()}. 
In the descriptions below M indicates
dry mass of structural biomass (either shoot mass MS or root mass MR).
}
\section{Units}{

\describe{
  \item{mmax}{Loss coefficient, per timestep (kg / kg M per timestep)}
  \item{gmax}{Growth coefficient, in (kg C  kg N  kg M^-2)^-1 per timestep}
  \item{KM}{Size dependency of mass-loss (kg M)}
  \item{CUmax}{Carbon uptake rate (kg C / kg shoot M per timestep)}
  \item{NUmax}{Nitrogen uptake rate (kg N / kg shoot M per timestep)}
  \item{KA}{Size dependency of uptake rates (kg M)}
  \item{Jc}{Substrate inhibition coefficient for carbon (kg C / kg M)}
  \item{Jn}{Substrate inhibition coefficient for nitrogen (in kg N / kg M)}
  \item{q}{Scaling coefficient for substrate transport, no units}
  \item{RHOc}{Specific carbon transport resistance, per timestep}
  \item{RHOn}{Specific nitrogen transport resistance, per timestep}
  \item{Fc}{Fraction of carbon in M (kg C / kg M)}
  \item{Fn}{Fraction of nitrogen in M (kg N / kg M)}
}
}

\keyword{datasets}
