#' @title Get coalition
#' @description This function returns the players that form the coalition whose binary order position coincides with the given integer.
#' @param num A binary order position of a coalition, as an integer.
#' @return The players that form the coalition whose binary order position is the given integer, as a vector.
#' @details A coalition \eqn{S\in 2^N} can be represented by the \eqn{n}-digit binary number \eqn{s_1\dots s_n} in which \eqn{s_i=1} if \eqn{i\in S} and \eqn{s_i=0} otherwise. The binary order position of a coalition \eqn{S\in 2^N} is given by \eqn{\sum_{i\in S} 2^{i-1}}.
#' @examples
#' num <- 5
#' getcoalition(num)
#' n <- 4
#' for (i in 1:(2^n - 1)){
#'   cat("[", i, "]", paste(getcoalition(i)),"\n")
#' }
#' @seealso \link{codebin2lex}, \link{codelex2bin}, \link{getcoalitionnumber}
#' @export

getcoalition <- function(num) {

  ################################
  ### Comprobación datos entrada###
  ################################

  if (num < 0 || num %% 1 != 0) {
    stop("'num' must be a positive integer.")
  }

  ################################
  ###### Cuerpo de la función######
  ################################

  # Jugador más grande

  J <- floor(log2(num)) + 1
  S <- c() # Inicializo la coalición S

  for (ii in 1:J)
  {
    if (num %% 2 == 1) {
      S <- c(S, ii)
    }
    num <- num %/% 2
  }

  ################################
  ###### Salidas de la función#####
  ################################

  return(S)
} # Fin de la función
