% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dummynull.R
\name{dummynull}
\alias{dummynull}
\title{Dummy and null players}
\usage{
dummynull(v, binary = FALSE, tol = 100 * .Machine$double.eps)
}
\arguments{
\item{v}{A characteristic function, as a vector.}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} is introduced in binary order instead of lexicographic order.}

\item{tol}{A tolerance parameter, as a non-negative number.\cr
By default, \code{tol=100*.Machine$double.eps}.}
}
\value{
Two different vectors are returned: one containing the dummy players and the other containing the null players.
}
\description{
Given a game, this function identifies its dummy players and null players.
}
\details{
Given a game \eqn{v\in G^N}, \eqn{i \in N} is said to be a dummy player
if \eqn{v(S) + v(\{i\}) = v(S \cup \{i\})} for all \eqn{S \subset N \setminus \{i\}}.

A dummy player \eqn{i \in N} is said to be a null player if \eqn{v(\{i\})=0}.
}
\examples{
v <- c(0,1,0,1,0,1,1)
dummynull(v)
# Checking if a particular player is a dummy player:
2 \%in\% dummynull(v)$dummy # player 2 is a dummy player in v
2 \%in\% dummynull(v)$null # player 2 is not a null player in v
}
