% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/museumpassgame.R
\name{museumpassgame}
\alias{museumpassgame}
\title{Museum pass game}
\usage{
museumpassgame(V, p = rep(1, dim(V)[2]), binary = FALSE)
}
\arguments{
\item{V}{A matrix of zeros and ones where each row represents a museum and each column represents a visitor. If museum \eqn{i} is visited by visitor \eqn{j}, \eqn{V_{ij}=1}; otherwise, \eqn{V_{ij}=0}.}

\item{p}{A vector containing the price that each visitor pays for their pass. By default, it is a vector of ones.}

\item{binary}{A logical value. By default, \code{binary=FALSE}.}
}
\value{
The characteristic function of the museum pass game, as a vector in binary order if \code{binary=TRUE} and in lexicographic order otherwise.
}
\description{
This function returns the characteristic function of the described museum pass game.
}
\details{
Let \eqn{N} be a non-empty and finite set of museums and let \eqn{U} be a non-empty and finite set of visitors.
The museum matrix, \eqn{V\in \{0,1\}^{N \times U}}, specifies which museums are visited by which visitors: \eqn{V_{ij}=1} if and only if museum \eqn{i\in N}
is visited by visitor \eqn{j\in U}. The vector \eqn{p\in\mathbb{R}^|U|_+} represents, for each visitor \eqn{j}, the price they pay for their museum pass
(all passes are equal, in the sense that they grant access to the same set of museums, but the price may not be the same for all visitors).

The total revenue is to be divided among the museums. Given a museum pass situation \eqn{(N,U,V,p)}, the museum pass game is defined by
\deqn{v(S)=\sum_{j\in U:N^j\subset S}p_j \ \text{for each coalition } S \in 2^{N},}
where \eqn{N^j=\{i\in N:V_{ij}=1\}} is the set of museums visited by \eqn{j\in U}.
}
\examples{
V <- rbind(c(1,0,1,1,0), c(0,1,1,1,0), c(1,1,0,0,1), c(1,0,1,0,1))
museumpassgame(V, p=c(1,1,4,5,8))
}
\references{
Ginsburgh, V. & Zang, I. (2003). The museum pass game and its value. \emph{Games and economic behavior}, 43(2), 322-325.
}
