% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_stability.R
\name{plot_stability}
\alias{plot_stability}
\title{Plot Stability of Model Predictions}
\usage{
plot_stability(predictions_matrix, type = c("range", "sd"), ...)
}
\arguments{
\item{predictions_matrix}{A numeric matrix or data.frame where each row
represents an observation and each column represents predictions from
a single model run or resample.}

\item{type}{Character string indicating what the error bars represent.
Either \code{"range"} (default) or \code{"sd"} (standard deviation).}

\item{...}{Additional arguments passed to \code{\link[graphics]{plot}}.}
}
\value{
No return value, called for side effects (plotting).
}
\description{
Creates a visualization showing the variability of model predictions
across multiple runs. This helps identify whether instability is
uniform across the dataset or concentrated on specific observations.
}
\details{
The plot displays the mean prediction for each observation with error
bars representing the range (minimum and maximum) or standard deviation
of predictions across runs.
}
\examples{
# Simulate predictions from 5 model runs
set.seed(42)
base_predictions <- sort(rnorm(50))
predictions <- matrix(
    rep(base_predictions, 5) + rnorm(250, sd = 0.2),
    ncol = 5
)

plot_stability(predictions, main = "Model Prediction Stability")

}
