% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/princompCustom.r
\name{princompCustom}
\alias{princompCustom}
\title{Custom version of princomp
The warning() at L53 substitutes the stop() in the original version of "princomp".}
\usage{
princompCustom(
  x,
  cor = FALSE,
  scores = TRUE,
  covmat = NULL,
  subset = rep_len(TRUE, nrow(as.matrix(x))),
  fix_sign = TRUE,
  ...
)
}
\arguments{
\item{x}{a numeric matrix or data frame which provides the data for the principal components analysis.}

\item{cor}{a logical value indicating whether the calculation should use the correlation matrix or the covariance matrix. (The correlation matrix can only be used if there are no constant variables.)}

\item{scores}{a logical value indicating whether the score on each principal component should be calculated.}

\item{covmat}{a covariance matrix, or a covariance list as returned by cov.wt (and cov.mve or cov.mcd from package MASS). If supplied, this is used rather than the covariance matrix of x.}

\item{subset}{an optional vector used to select rows (observations) of the data matrix x.}

\item{fix_sign}{Should the signs of the loadings and scores be chosen so that the first element of each loading is non-negative?}
}
\value{
Returns a list with class "princomp", for details see \code{stats::princomp}
}
\description{
Custom version of princomp
The warning() at L53 substitutes the stop() in the original version of "princomp".
}
\keyword{internal}
