% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upsilon.gof.test.R
\name{upsilon.gof.test}
\alias{upsilon.gof.test}
\title{Upsilon Goodness-of-Fit Test for Count Data}
\usage{
upsilon.gof.test(
  x,
  p = rep(1/length(x), length(x)),
  rescale.p = TRUE,
  log.p = FALSE
)
}
\arguments{
\item{x}{A numeric vector representing observed counts. Must be non-negative.}

\item{p}{A numeric vector of probabilities of the same length as \code{x}.
Defaults to a uniform distribution (1/length(x)).}

\item{rescale.p}{Logical. If \code{TRUE} (default), \code{p} is rescaled to sum to 1.
If \code{FALSE}, \code{p} must sum to 1, otherwise an error is raised.}

\item{log.p}{a logical. If \code{TRUE}, 
the \emph{p}-value is calculated in
closed form to \strong{natural logarithm} of \emph{p}-value 
to improve numerical precision when
\emph{p}-value approaches zero.
Defaults to \code{FALSE}.}
}
\value{
A list with class \code{"htest"} containing:
\item{statistic}{The Upsilon test statistic.}
\item{parameter}{The degrees of freedom (k - 1).}
\item{p.value}{The p-value of the test.}
\item{estimate}{The effect size.}
\item{method}{A character string indicating the method used.}
\item{data.name}{A character string giving the name(s) of the data.}
\item{observed}{The observed counts.}
\item{expected}{The expected counts.}
\item{residuals}{The Pearson residuals.}
\item{p.normalized}{The probability vector used (after rescaling if applicable).}
}
\description{
(FOR INTERNAL USE ONLY) Performs the Upsilon Goodness-of-Fit test to determine if a sample of 
observed counts fits a specified probability distribution.
The Upsilon statistic uses a specific normalization (dividing by the average expected count)
which differs from the standard Pearson's Chi-squared test.
}
\examples{
library("Upsilon")

# Test against uniform distribution
counts <- c(10, 20, 30)
upsilon.gof.test(counts)
}
\keyword{internal}
