% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/types.R
\name{Result}
\alias{Result}
\title{Single Search Result}
\description{
Represents a single search result with id, text, score, and metadata
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{id}}{Document ID}

\item{\code{text}}{Document text}

\item{\code{score}}{Relevance score}

\item{\code{metadata}}{Document metadata}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Result-new}{\code{Result$new()}}
\item \href{#method-Result-print}{\code{Result$print()}}
\item \href{#method-Result-clone}{\code{Result$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Result-new"></a>}}
\if{latex}{\out{\hypertarget{method-Result-new}{}}}
\subsection{Method \code{new()}}{
Create a new Result object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Result$new(id, text, score, metadata = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{Document ID}

\item{\code{text}}{Document text}

\item{\code{score}}{Relevance score}

\item{\code{metadata}}{Optional metadata list}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Result-print"></a>}}
\if{latex}{\out{\hypertarget{method-Result-print}{}}}
\subsection{Method \code{print()}}{
Print result summary
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Result$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Result-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Result-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Result$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
