% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ops.R
\name{adj_laplacian}
\alias{adj_laplacian}
\title{Compute the Laplacian matrix of an adjacency list}
\usage{
adj_laplacian(x, sparse = TRUE)
}
\arguments{
\item{x}{An \code{adj} list}

\item{sparse}{Whether to return a sparse matrix (of class \code{dgCMatrix})
or a dense matrix. Requires the \code{Matrix} package for sparse output.}
}
\value{
A matrix representing the Laplacian of the graph.
}
\description{
The Laplacian matrix of a graph is defined as \code{L = D - A}, where \code{D} is the
degree matrix (a diagonal matrix where \code{D[i, i]} is the degree of node \code{i})
and \code{A} is the adjacency matrix.
}
\examples{
a <- adj(konigsberg$bridge_to, ids = konigsberg$area, duplicates = "allow")
L <- adj_laplacian(a, sparse = FALSE)
L

# count spanning trees (any minor of the Laplacian)
det(L[-1, -1])
}
