% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_function}
\alias{assert_function}
\title{Is Argument a Function?}
\usage{
assert_function(
  arg,
  params = NULL,
  optional = FALSE,
  arg_name = rlang::caller_arg(arg),
  message = NULL,
  class = "assert_function",
  call = parent.frame()
)
}
\arguments{
\item{arg}{A function

The function to be checked

\describe{
\item{Default value}{none}
}}

\item{params}{A character vector

A character vector of expected argument names for the aforementioned function in \code{arg}.
If ellipsis, \code{...}, is included in the function formals of the function in \code{arg},
this argument, \code{params} will be ignored, accepting all values of the character vector.

\describe{
\item{Default value}{\code{NULL}}
}}

\item{optional}{Is the checked argument optional?

If set to \code{FALSE} and \code{arg} is \code{NULL} then an error is thrown.

\describe{
\item{Default value}{\code{FALSE}}
}}

\item{arg_name}{string indicating the label/symbol of the object being checked.

\describe{
\item{Default value}{\code{rlang::caller_arg(arg)}}
}}

\item{message}{string passed to \code{cli::cli_abort(message)}.
When \code{NULL}, default messaging is used (see examples for default messages).
\code{"{arg_name}"} can be used in messaging.

\describe{
\item{Default value}{\code{NULL}}
}}

\item{class}{Subclass of the condition.}

\item{call}{The execution environment of a currently running
function, e.g. \code{call = caller_env()}. The corresponding function
call is retrieved and mentioned in error messages as the source
of the error.

You only need to supply \code{call} when throwing a condition from a
helper function which wouldn't be relevant to mention in the
message.

Can also be \code{NULL} or a \link[rlang:topic-defuse]{defused function call} to
respectively not display any call or hard-code a code to display.

For more information about error calls, see \ifelse{html}{\link[rlang:topic-error-call]{Including function calls in error messages}}{\link[rlang:topic-error-call]{Including function calls in error messages}}.}
}
\value{
The function throws an error
\itemize{
\item if the argument is not a function or
\item if the function does not provide all arguments as specified for the
\code{params} argument (assuming ellipsis is not in function formals)
}
}
\description{
Checks if the argument is a function and if all expected arguments are
provided by the function.
}
\examples{
example_fun <- function(fun) {
  assert_function(fun, params = c("x"))
}

example_fun(mean)

try(example_fun(1))

try(example_fun(sum))
}
\seealso{
Checks for valid input and returns warning or errors messages: 
\code{\link{assert_atomic_vector}()},
\code{\link{assert_character_scalar}()},
\code{\link{assert_character_vector}()},
\code{\link{assert_data_frame}()},
\code{\link{assert_date_vector}()},
\code{\link{assert_expr}()},
\code{\link{assert_expr_list}()},
\code{\link{assert_filter_cond}()},
\code{\link{assert_integer_scalar}()},
\code{\link{assert_list_element}()},
\code{\link{assert_list_of}()},
\code{\link{assert_logical_scalar}()},
\code{\link{assert_named}()},
\code{\link{assert_numeric_vector}()},
\code{\link{assert_one_to_one}()},
\code{\link{assert_param_does_not_exist}()},
\code{\link{assert_s3_class}()},
\code{\link{assert_same_type}()},
\code{\link{assert_symbol}()},
\code{\link{assert_unit}()},
\code{\link{assert_vars}()},
\code{\link{assert_varval_list}()}
}
\concept{assertion}
\keyword{assertion}
