% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adw.R
\name{points2grid_vector}
\alias{points2grid_vector}
\title{Points were to converted grids using a local gridding method.}
\usage{
points2grid_vector(dd, extent, gridsize = 5)
}
\arguments{
\item{dd}{a input dataframe which contains the column names of lon, lat, value.}

\item{extent}{a extent numeric vector (latitude and longitude) of length 4 in
the order c(xmin, xmax, ymin, ymax).}

\item{gridsize}{the grid size, i.e. the grid resolution. units: degree.}
}
\value{
a regular latitude-longitude dataframe grid (grid values).
}
\description{
The irregularly-spaced data of points are converted onto regular
latitude-longitude grids by averaging all stations in grid-boxes.
}
\examples{
# set.seed(2)
# dd <- data.frame(lon = runif(100, min = 110, max = 117),
#                  lat = runif(100, min = 31, max = 37),
#                  value = runif(100, min = -10, max = 10))
# head(dd)
# # example
# grd <- points2grid(dd, extent = c(110, 117, 31, 37), gridsize = 0.5)
# head(grd)
}
\references{
Jones, P. D., and M. Hulme, 1996: Calculating regional climatic time series for temperature and precipitation: Methods and illustrations. Int. J. Climatol., 16, 361–377, https://doi.org/10.1002/(SICI)1097-0088(199604)16:4<361::AID-JOC53>3.0.CO;2-F.
}
