% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weight_varIndivInterval.R
\name{weight_varIndivInterval}
\alias{weight_varIndivInterval}
\title{Weighting method: Variation in individuals’ interval widths}
\usage{
weight_varIndivInterval(expert_judgements)
}
\arguments{
\item{expert_judgements}{A dataframe in the form of \link{data_ratings}}
}
\value{
A tibble in the form of the input \code{expert_judgements} argument with additional columns
supplying the calculated weight for each row's observation.
}
\description{
Calculates weights based on the variability of interval widths
within individuals.
}
\details{
This function is used inside \link{IntervalWAgg} for aggregation types \code{"VarIndIntWAgg"}
and \code{"KitchSinkWAgg"}. It calculates the difference between individual's upper and
lower estimates, then calculates the variance in this interval across each individual's
claim assessments.
\loadmathjax
\mjdeqn{w\_varIndivInterval_{i} = var\{(U_{i,d}-L_{i,d}):c=1,...,C\}}{ascii}
}
