% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_principal.R
\name{PlotPS}
\alias{PlotPS}
\title{Plot the proportion of principal strata (R)}
\usage{
PlotPS(
  res,
  y.min = 0,
  y.max = 0.75,
  col.values = c("blue", "black", "red", "brown"),
  label = TRUE,
  r.labels = c("safe", " easily             \\n preventable    ",
    "\\n          preventable\\n", "  risky"),
  label.position = c("top", "top", "top", "bottom"),
  top.margin = 0.02,
  bottom.margin = 0.02,
  label.size = 6.5
)
}
\arguments{
\item{res}{A \code{data.frame} generated with \code{CalPS}.}

\item{y.min}{Minimum value of y-axis.}

\item{y.max}{Maximum value of y-axis.}

\item{col.values}{Color of point for each principal stratum.}

\item{label}{A logical argument whether to specify label of each principal stratum. The default is \code{TRUE}.}

\item{r.labels}{Label of each principal stratum.}

\item{label.position}{The position of labels.}

\item{top.margin}{Top margin of labels.}

\item{bottom.margin}{Bottom margin of labels.}

\item{label.size}{Size of label.}
}
\value{
A ggplot.
}
\description{
See Figure 3 for example.
}
\examples{
\donttest{
data(synth)
sample_mcmc <- AiEvalmcmc(data = synth, n.mcmc = 10)
subgroup_synth <- list(
  1:nrow(synth), which(synth$Sex == 0), which(synth$Sex == 1),
  which(synth$Sex == 1 & synth$White == 0), which(synth$Sex == 1 & synth$White == 1)
)
sample_apce <- CalAPCE(
  data = synth, mcmc.re = sample_mcmc,
  subgroup = subgroup_synth
)
sample_ps <- CalPS(sample_apce[["P.R.mcmc"]])
PlotPS(sample_ps, col.values = c("blue", "black", "red", "brown", "purple"), label = FALSE)
}

}
