% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PointMap.R
\docType{methods}
\name{links,PointMap-method}
\alias{links,PointMap-method}
\title{Get the PointMap links}
\usage{
\S4method{links}{PointMap}(map)
}
\arguments{
\item{map}{A PointMap}
}
\value{
A matrix with the linked refs
}
\description{
Get the PointMap links
}
\examples{
mifFile <- system.file(
    "extdata", "testdata", "gallery",
    "gallery_lines.mif",
    package = "alcyon"
  )
  sfMap <- st_read(mifFile,
    geometry_column = 1L, quiet = TRUE
  )
  pointMap <- makeVGAPointMap(
    sfMap,
    gridSize = 0.04,
    fillX = 3.01,
    fillY = 6.7,
    maxVisibility = NA,
    boundaryGraph = FALSE,
    verbose = FALSE
  )
linkRefs(pointMap, 1835056L, 7208971L)
links(pointMap)
}
