% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_covariates.R
\name{calculate_hms}
\alias{calculate_hms}
\title{Calculate wildfire smoke covariates}
\usage{
calculate_hms(from, locs, locs_id = NULL, radius = 0, geom = FALSE, ...)
}
\arguments{
\item{from}{SpatVector(1). Output of \code{process_hms()}.}

\item{locs}{data.frame, characater to file path, SpatVector, or sf object.}

\item{locs_id}{character(1). Column within \code{locations} CSV file
containing identifier for each unique coordinate location.}

\item{radius}{integer(1). Circular buffer distance around site locations.
(Default = 0).}

\item{geom}{FALSE/"sf"/"terra".. Should the function return with geometry?
Default is \code{FALSE}, options with geometry are "sf" or "terra". The
coordinate reference system of the \code{sf} or \code{SpatVector} is that of \code{from.}}

\item{...}{Placeholders.}
}
\value{
a data.frame or SpatVector object
}
\description{
Extract wildfire smoke plume values at point locations. Returns a
\code{data.frame} object containing \code{locs_id}, date, and binary variable
for wildfire smoke plume density inherited from \code{from} (0 = point not
covered by wildfire smoke plume; 1 = point covered by wildfire smoke plume).
}
\examples{
## NOTE: Example is wrapped in `\dontrun{}` as function requires a large
##       amount of data which is not included in the package.
\dontrun{
loc <- data.frame(id = "001", lon = -78.90, lat = 35.97)
calculate_hms(
  from = hms, # derived from process_hms() example
  locs = loc,
  locs_id = "id",
  radius = 0,
  geom = FALSE
)
}
}
\seealso{
\code{\link[=process_hms]{process_hms()}}
}
\author{
Mitchell Manware
}
