% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{process_modis_warp}
\alias{process_modis_warp}
\title{Warp MODIS swath data into rectilinear grid raster}
\usage{
process_modis_warp(
  path = NULL,
  cellsize = 0.1,
  threshold = cellsize * 4,
  crs = 4326,
  ...
)
}
\arguments{
\item{path}{File path of MODIS swath with exact sub-dataset specification.}

\item{cellsize}{numeric(1). Cell size (spatial resolution) of
output rectilinear grid raster.}

\item{threshold}{numeric(1). Maximum distance to fill gaps if occur.}

\item{crs}{integer(1)/character(1). Coordinate system definition.
Should be compatible with EPSG codes or WKT2.
See \code{\link[terra:crs]{terra::crs}} and \code{\link[sf:st_crs]{sf::st_crs}} / \href{https://epsg.io/}{EPSG}}

\item{...}{For internal use.}
}
\value{
a \code{stars} object
}
\description{
Swath data is a type of MODIS data,
where curvilinear points are stored with varying resolution depending on
the relative position of the sensor axis. As this type of data
typically does not work well with planar spatial data, users
should warp or rectify this data into a rectilinear raster.
Main procedure is done with \code{\link[stars:st_warp]{stars::st_warp}}, in which users are able to
customize the threshold to fill potential gaps that appear where
the target resolution is finer than the local resolution of curvilinear
grid points.
}
\note{
This function handles one file at a time.
}
\examples{
## NOTE: Example is wrapped in `\dontrun{}` as function requires a large
##       amount of data which is not included in the package.
\dontrun{
mod06l2_warp <- process_modis_warp(
  path = paste0(
    "HDF4_EOS:EOS_SWATH:",
    list.files(
      "./data/mod06l2",
      full.names = TRUE,
      pattern = ".hdf"
    )[1],
    ":mod06:Cloud_Fraction"
  ),
  cellsize = 0.1,
  threshold = 0.4,
  crs = 4326
)
}
}
\seealso{
\code{\link[terra:rectify]{terra::rectify}}
}
\author{
Insang Song
}
\keyword{internal}
