% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot.R
\docType{methods}
\name{rec_plot}
\alias{rec_plot}
\alias{plot,RECE,missing-method}
\title{Plot a Radiocarbon Event Count Ensemble}
\usage{
\S4method{plot}{RECE,missing}(x, calendar = get_calendar(), ...)
}
\arguments{
\item{x}{An \code{\linkS4class{RECE}} object.}

\item{calendar}{An \code{\link[aion:TimeScale-class]{aion::TimeScale}} object specifying the target
calendar (see \code{\link[aion:calendar]{aion::calendar()}}). If \code{NULL}, \emph{rata die} are returned.}

\item{...}{Further parameters to be passed to \code{\link[graphics:image]{graphics::image()}}.}
}
\value{
\code{image()} is called it for its side-effects: it results in a graphic being
displayed (invisibly returns \code{x}).
}
\description{
Plot a Radiocarbon Event Count Ensemble
}
\references{
Carleton, W. C. (2021). Evaluating Bayesian Radiocarbon‐dated Event Count
(REC) Models for the Study of Long‐term Human and Environmental Processes.
\emph{Journal of Quaternary Science}, 36(1): 110‑23. \doi{10.1002/jqs.3256}.
}
\seealso{
Other radiocarbon tools: 
\code{\link{F14C}},
\code{\link{c14_calibrate}()},
\code{\link{c14_combine}()},
\code{\link{c14_curve}()},
\code{\link{c14_ensemble}()},
\code{\link{c14_plot}},
\code{\link{c14_sample}()},
\code{\link{c14_spd}()},
\code{\link{c14_uncalibrate}()}
}
\author{
N. Frerebeau
}
\concept{radiocarbon tools}
