% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculations.R
\name{calculate_influence}
\alias{calculate_influence}
\title{Calculate the Influence Index for a Leaf Node}
\usage{
calculate_influence(node)
}
\arguments{
\item{node}{A \code{data.tree} \code{Node} object, which must be a leaf.}
}
\value{
The function has no return value; it modifies the \code{influence_index}
attribute of the input \code{node} by side-effect.
}
\description{
Determines the strategic importance (the "influence") of asking an unanswered
leaf question. The influence is calculated by aggregating the logical indices
(\code{true_index} and \code{false_index}) of all its ancestor nodes.
}
\details{
The influence index is a measure of how much a single leaf's answer can
contribute to the final conclusion. It is calculated as the sum of two
products:
Influence = \code{prod(ancestor_true_indices) + prod(ancestor_false_indices)}

The function will set \code{influence_index} to \code{NA} under two conditions,
as the question is considered moot:
\enumerate{
\item The leaf node itself has already been answered.
\item Any of the leaf's ancestors has a determined \code{answer} (\code{TRUE} or \code{FALSE}),
meaning the branch has already been logically resolved.
}

This function is intended to be used with \code{tree$Do(..., filterFun = isLeaf)}.
}
\keyword{internal}
